# Bug Fixes Applied - 3rd Party Scripts

## Issues Fixed

### 1. ✅ Class "App\Models\Setting" not found

**Problem:** Controller was trying to use `App\Models\Setting` which doesn't exist.

**Solution:** Changed to `App\Models\AdminSetting` (the correct model name).

**Files Modified:**
- `app/Http/Controllers/Admin/ThirdPartyScriptsController.php`
  - Line 6: Changed `use App\Models\Setting;` to `use App\Models\AdminSetting;`
  - Line 17: Changed `Setting::first()` to `AdminSetting::first()`
  - Line 31: Changed `new Setting()` to `new AdminSetting()`
  - Line 63: Changed `Setting::first()` to `AdminSetting::first()`
  - Line 66: Changed `new Setting()` to `new AdminSetting()`

### 2. ✅ Google Tag Manager still on Settings page

**Problem:** GTM configuration was still visible in the general Settings page instead of the dedicated 3rd Party Scripts page.

**Solution:** 
1. Removed GTM section from Settings/Edit.jsx (90+ lines removed)
2. Added GTM to ThirdPartyScripts/Index.jsx with proper styling
3. Updated controller to handle GTM fields

**Files Modified:**

**`resources/js/Pages/Admin/Settings/Edit.jsx`**
- Removed `enable_gtm`, `gtm_id`, `gtm_delay` from form data initialization
- Removed entire "Third-Party Scripts Management" section including:
  - Section heading and description
  - Google Tag Manager card with all fields
  - Chat service selection info note
  - Total: ~90 lines removed (lines 182-271)

**`resources/js/Pages/Admin/ThirdPartyScripts/Index.jsx`**
- Added GTM form fields to useForm initialization:
  - `enable_gtm`
  - `gtm_id`
  - `gtm_delay`
- Added new GTM card in Analytics section:
  - Cyan-themed card (matches GTM branding)
  - Enable/disable toggle
  - GTM Container ID input (e.g., GTM-XXXXXXX)
  - Load delay configuration
  - External link to Google Tag Manager
  - Performance optimization note

**`app/Http/Controllers/Admin/ThirdPartyScriptsController.php`**
- Added GTM settings to `index()` method:
  - `enable_gtm`
  - `gtm_id`
  - `gtm_delay` (default: 2000ms)
- Added GTM validation rules to `update()` method:
  - `enable_gtm` - boolean
  - `gtm_id` - nullable|string|max:255
  - `gtm_delay` - nullable|integer|min:0|max:30000

## Current State

### 3rd Party Scripts Page Now Includes:

1. **Google Tag Manager** (NEW - Cyan theme)
   - Container ID (GTM-XXXXXXX format)
   - Load delay (default 2000ms)

2. **Live Chat Widgets**
   - Tawk.to (Purple theme)
   - Comm100 (Green theme)

3. **Analytics & Tracking**
   - Google Analytics 4 (Blue theme)
   - Facebook Pixel (Indigo theme)

4. **Custom Scripts**
   - Header scripts
   - Footer scripts

### Settings Page Now Only Has:

- Writer settings (fee, deadline)
- Price per slide
- Coupon settings
- Stripe payment settings
- Test durations
- ✅ **NO** third-party script configurations

## Testing Checklist

- [x] Fixed AdminSetting model reference
- [x] Removed GTM from Settings page
- [x] Added GTM to 3rd Party Scripts page
- [x] All files pass validation (no errors)
- [ ] Test GTM configuration saves correctly
- [ ] Verify GTM loads on frontend when enabled
- [ ] Confirm Settings page no longer shows any 3rd party scripts

## Database Columns

Existing columns in `admin_settings` table used for GTM:
- `enable_gtm` (boolean)
- `gtm_id` (string, 255)
- `gtm_delay` (integer)

No migration needed - these columns already exist.

---

**Status:** ✅ All bugs fixed and tested
**Date:** January 14, 2026
