# Homepage CMS Editability Audit

## 🔍 **Current State Analysis**

### **Homepage Content Blocks:**
1. Hero (order 1)
2. About (order 2)
3. Services (order 3)
4. FAQs (order 4)
5. Stats (order 4) - duplicate order!
6. Testimonials (order 5)
7. Contact (order 7)
8. CTA (order 8)

---

## ❌ **CRITICAL ISSUES FOUND**

### **Issue #1: Hero Block Editor Doesn't Match Homepage Hero**

**Homepage Hero Has (21 fields):**
```
- headlinePrimary
- headlineHighlight  
- headlineSuffix
- trustText
- paragraph
- bullet1, bullet2, bullet3, bullet4
- ctaPrimaryText, ctaPrimaryHref
- ctaSecondaryText, ctaSecondaryHref
- stat1Value, stat1Label
- stat2Value, stat2Label
- stat3Value, stat3Label
- heroImage, heroAlt
```

**HeroBlockEditor Provides (6 fields):**
```
- title
- subtitle
- description (TinyMCE)
- cta_text, cta_link
- background_image, background_color
```

**❌ MISMATCH:** The editor doesn't support ANY of the actual homepage hero fields!

---

### **Issue #2: Missing Dedicated Editors**

**Homepage Blocks Using GenericBlockEditor:**
- ❌ About block → Uses `GenericBlockEditor` (just JSON editor)
- ❌ Services block → Uses `ServicesBlockEditor` (might be okay)
- ❌ Stats block → Uses `StatsBlockEditor` (might be okay)
- ❌ Contact block → Uses `ContactBlockEditor` (might be okay)
- ❌ CTA block → Uses `CTABlockEditor` (might be okay)

**Homepage Blocks With Proper Editors:**
- ✅ Hero → `HeroBlockEditor` (but doesn't match fields!)
- ✅ Testimonials → `TestimonialsBlockEditor`
- ✅ FAQs → `FAQsBlockEditor`

---

### **Issue #3: Which Editor is Actually Being Used?**

Looking at ContentBlockEditor.jsx case statements:

**Homepage Blocks:**
- `hero` → Uses `HeroBlockEditor` (WRONG fields)
- `about` → **NO CASE!** Falls to `GenericBlockEditor` (JSON only)
- `services` → Uses `ServicesBlockEditor` (need to check)
- `faqs` → Uses `FAQsBlockEditor` (probably okay)
- `stats` → **NO CASE!** Falls to `GenericBlockEditor` (JSON only)
- `testimonials` → Uses `TestimonialsBlockEditor` (probably okay)
- `contact` → **NO CASE!** Falls to `GenericBlockEditor` (JSON only)
- `cta` → Uses `CTABlockEditor` (need to check)

---

## 🎯 **What Needs to Be Done**

### **Priority 1: Fix Hero Block Editor**

Create a proper `HomeHeroBlockEditor` that matches actual homepage hero fields:

**Required Fields with TinyMCE:**
- ✅ headlinePrimary (Input)
- ✅ headlineHighlight (Input)
- ✅ headlineSuffix (Input)
- ✅ trustText (Input)
- ✅ **paragraph (TinyMCE)** ← Rich text
- ✅ bullet1-4 (Inputs)
- ✅ CTA fields (Inputs)
- ✅ Stats fields (Inputs)
- ✅ Image fields (Inputs)

---

### **Priority 2: Create About Block Editor**

Currently using Generic JSON editor!

**Fields Needed:**
- title (Input)
- **description (TinyMCE)** ← Rich text
- mission_title (Input)
- **mission_description (TinyMCE)** ← Rich text
- features (Array editor)
- about_image, about_image_alt (Inputs)

---

### **Priority 3: Create/Fix Services Block Editor**

**Fields in Database:**
- title (Input)
- **subtitle (TinyMCE)** ← Rich text
- services (Array of objects - needs custom editor)

Need to check if current ServicesBlockEditor supports these.

---

### **Priority 4: Create/Fix Stats Block Editor**

Currently using Generic!

**Fields Needed:**
- title (Input)
- **subtitle (TinyMCE)** ← Rich text
- main_stats (Array editor)
- writer_stats (Array editor)
- additional_stats (Array editor)
- expertise_distribution (Array editor)

---

### **Priority 5: Create Contact Block Editor**

Currently using Generic!

**Fields Needed:**
- title (Input)
- **subtitle (TinyMCE)** ← Rich text
- contact_form (Object editor)
- contact_info (Object editor)
- social_links (Array editor)

---

### **Priority 6: Create/Fix CTA Block Editor**

**Fields in Database:**
- title (Input)
- **description (TinyMCE)** ← Rich text
- background_color (Color picker)
- benefits (Array editor)
- Button fields (Inputs)

Need to check if current CTABlockEditor supports these.

---

## 📊 **Summary**

### **Homepage Blocks Editability:**

| Block | Has Editor? | Has TinyMCE? | Status |
|-------|-------------|--------------|--------|
| **Hero** | ⚠️ Wrong fields | ❌ No | ❌ BROKEN |
| **About** | ❌ Generic JSON | ❌ No | ❌ BROKEN |
| **Services** | ⚠️ Unknown | ⚠️ Unknown | ⚠️ CHECK |
| **FAQs** | ✅ Yes | ✅ Probably | ✅ OKAY |
| **Stats** | ❌ Generic JSON | ❌ No | ❌ BROKEN |
| **Testimonials** | ✅ Yes | ⚠️ Unknown | ⚠️ CHECK |
| **Contact** | ❌ Generic JSON | ❌ No | ❌ BROKEN |
| **CTA** | ⚠️ Unknown | ⚠️ Unknown | ⚠️ CHECK |

**Results:**
- ❌ **Broken:** 4 blocks (Hero, About, Stats, Contact)
- ⚠️ **Need to Check:** 3 blocks (Services, Testimonials, CTA)
- ✅ **Working:** 1 block (FAQs)

---

## 🔧 **Action Plan**

### **Phase 1: Audit Existing Editors (30 min)**
Check what editors already exist and what they support:
1. Check ServicesBlockEditor
2. Check TestimonialsBlockEditor
3. Check CTABlockEditor
4. Check FAQsBlockEditor

### **Phase 2: Create Missing Editors (4-6 hours)**
Create dedicated editors for:
1. Home Hero Block Editor (21 fields with TinyMCE)
2. About Block Editor (7 fields with TinyMCE)
3. Stats Block Editor (complex arrays)
4. Contact Block Editor (structured data)

### **Phase 3: Add TinyMCE Where Needed (2-3 hours)**
Add RichTextEditor component to:
- Hero paragraph field
- About description and mission_description
- Services subtitle
- Stats subtitle
- Contact subtitle
- CTA description
- Any other long-text fields

### **Phase 4: Test Everything (1 hour)**
Ensure all homepage content is editable without touching code.

---

## 🎯 **Expected Outcome**

**After fixes:**
- ✅ All homepage blocks have proper dedicated editors
- ✅ All long-text fields use TinyMCE
- ✅ No more JSON editing (user-friendly forms)
- ✅ True CMS experience - edit everything from admin panel

---

## 📝 **Next Steps**

1. Audit existing block editors
2. Identify what's missing
3. Create/update editors with TinyMCE integration
4. Test editing each block
5. Document which fields support rich text

---

Ready to start? Let's begin with auditing the existing editors to see what's already there!

