# Service Page Canonical Schema Reference

## 1. Current Block Inventory Snapshot

| Page Group | Typical Block Keys | Block Types Today | Notes |
|------------|--------------------|-------------------|-------|
| Core service pages (`research-papers`, `dissertation-writing`, `assignments`, etc.) | `*_hero`, `*_overview`, `*_process`, `*_benefits`, `*_testimonials`, `*_faqs`, `*_cta`, `*_related_services`, `*_support_pages`, `*_resource_links` | `service_hero`, `service_overview`, `service_process`, `service_benefits`, `service_testimonials`, `service_faqs`, `service_cta`, `internal_links` (×3) | Uses dedicated `Service*BlockEditor` components. |
| Money pages (`buy-essays-online`, `affordable-essay-writing`, `cheap-essays-online`) | Same 10 keys as core pages plus long-form keys (`*_trust`, `*_writer_selection`, `*_reasons`, `*_originality`, `*_join_experts`, `*_types`, `*_hiring_steps`, `*_writer_standout`, `*_service_benefits`, `*_peace_of_mind`, `*_quality_score`) | Mixed labels (`hero`, `content`, `steps`, `benefits`, `links`, etc.) | Extra scrollable content rendered via `ScrollableContentSection`; inconsistent `block_type` naming. |

Observations:
- Both groups already share the same core structure; divergences come from block type labels and the additional long-form markdown sections on money pages.
- `is_active` is persisted for every block, but sub-items (key points, sections, etc.) do not currently have their own toggle flag in stored content.

---

## 2. Canonical Block Order & Naming

All service pages will adopt the following ordered blocks. Optional blocks remain in the schema but can be disabled per page via `is_active`.

| Order | Block Key Pattern | Canonical `block_type` | Required | Description |
|-------|-------------------|------------------------|----------|-------------|
| 1 | `<slug>_hero` | `service_hero` | ✅ | Hero headline, description, key points, CTA, trust signals. |
| 2 | `<slug>_overview` | `service_overview` | ✅ | Section title, rich overview description, feature cards. |
| 3 | `<slug>_process` | `service_process` | ✅ | Ordered process steps with icons and descriptions. |
| 4 | `<slug>_benefits` | `service_benefits` | ✅ | Benefits grid + optional CTA. |
| 5 | `<slug>_testimonials` | `service_testimonials` | ✅ | Testimonials array + trust metrics. |
| 6 | `<slug>_faqs` | `service_faqs` | ✅ | FAQ entries. |
| 7 | `<slug>_cta` | `service_cta` | ✅ | Final CTA content (copy, buttons, guarantees). |
| 8 | `<slug>_related_services` | `service_links` | ✅ | Cards linking to related services. |
| 9 | `<slug>_support_pages` | `service_links` | ✅ | Support resources (pricing, guarantees, writers, etc.). |
| 10 | `<slug>_resource_links` | `service_links` | ✅ | Additional resources/blog posts. |
| 11+ | `<slug>_<topic>` | `service_scrollable` | Optional | Scrollable deep-dive sections rendered inside the horizontal scroller. |

### Naming Conventions
- Block keys remain `<slug>_<section>` for backwards compatibility.
- Scrollable sections reuse the existing topic suffixes (`trust`, `writer_selection`, etc.).
- `block_type` values follow the `service_*` namespace (`service_links`, `service_scrollable`).

---

## 3. Block Content Shape

### 3.1 `service_hero`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "keyPoints": [
    { "text": "string", "is_active": true }
  ],
  "ctaText": "string",
  "ctaLink": "string",
  "trustSignals": [
    { "text": "string", "is_active": true }
  ],
  "is_active": true
}
```

### 3.2 `service_overview`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "features": [
    {
      "icon": "Award",
      "title": "string",
      "description_html": "<p>...</p>",
      "is_active": true
    }
  ],
  "is_active": true
}
```

### 3.3 `service_process`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "steps": [
    {
      "number": 1,
      "icon": "Target",
      "title": "string",
      "description_html": "<p>...</p>",
      "is_active": true
    }
  ],
  "is_active": true
}
```

### 3.4 `service_benefits`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "benefits": [
    {
      "icon": "Award",
      "title": "string",
      "description_html": "<p>...</p>",
      "is_active": true
    }
  ],
  "ctaText": "string",
  "ctaLink": "string",
  "is_active": true
}
```

### 3.5 `service_testimonials`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "testimonials": [
    {
      "text_html": "<p>...</p>",
      "author": "string",
      "role": "string",
      "rating": 5,
      "is_active": true
    }
  ],
  "trustMetrics": {
    "totalReviews": "string",
    "averageRating": "string",
    "satisfactionRate": "string"
  },
  "is_active": true
}
```

### 3.6 `service_faqs`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "faqs": [
    {
      "question": "string",
      "answer_html": "<p>...</p>",
      "is_active": true
    }
  ],
  "is_active": true
}
```

### 3.7 `service_cta`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "benefits": [ { "text": "string", "icon": "🏆", "is_active": true } ],
  "primaryButtonText": "string",
  "primaryButtonLink": "string",
  "secondaryButtonText": "string",
  "secondaryButtonLink": "string",
  "bgColor": "blue",
  "urgencyText": "string",
  "guarantees": [ { "text": "string", "is_active": true } ],
  "trustBadges": [ { "text": "string", "is_active": true } ],
  "is_active": true
}
```

### 3.8 `service_links`
```json
{
  "title": "string",
  "description_html": "<p>...</p>",
  "links": [
    {
      "title": "string",
      "url": "string",
      "description_html": "<p>...</p>",
      "is_active": true
    }
  ],
  "is_active": true
}
```

### 3.9 `service_scrollable`
```json
{
  "eyebrow": "string",
  "title": "string",
  "description_html": "<p>...</p>",
  "preferredHeight": 480,
  "sections": [],
  "is_active": true
}
```

> **Storage Format:** All rich text values are stored as sanitized HTML strings generated by TipTap to maintain compatibility with existing frontend components. TipTap JSON can be preserved in-memory for editing but is not persisted.

---

## 4. JSON Schema Skeleton

```json
{
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "ServicePage",
  "type": "object",
  "properties": {
    "slug": { "type": "string" },
    "title": { "type": "string" },
    "blocks": {
      "type": "array",
      "items": {
        "type": "object",
        "required": ["block_type", "block_key", "order", "content", "is_active"],
        "properties": {
          "block_type": { "type": "string", "enum": ["service_hero", "service_overview", "service_process", "service_benefits", "service_testimonials", "service_faqs", "service_cta", "service_links", "service_scrollable"] },
          "block_key": { "type": "string" },
          "order": { "type": "integer", "minimum": 1 },
          "is_active": { "type": "boolean" },
          "content": { "type": "object" }
        }
      }
    }
  },
  "required": ["slug", "title", "blocks"]
}
```

---

## 5. TipTap Integration Plan

1. **Editor Component**
   - Reuse the homepage TipTap configuration (extensions, toolbar) to ensure consistent UX.
   - Provide helper utilities to convert TipTap JSON → HTML (`generateHTML`) and HTML → JSON (for editing legacy content).

2. **Data Flow**
   - On load: convert stored HTML strings into TipTap JSON using `generateJSON` to initialize editors.
   - On save: sanitize and persist HTML strings; optional storage of JSON in a separate column can be explored later for advanced features.

3. **Migration Tasks**
   - Identify all CMS editor components still referencing TinyMCE; replace with shared `TipTapEditor` wrapper.
   - Update backend validation to accept HTML from TipTap (already sanitized) and reject empty `<p><br></p>` placeholders.
   - Run QA to ensure TipTap-formatted HTML renders identically to existing TinyMCE output on the frontend.

---

## 6. Outstanding Decisions (to confirm with stakeholders)

- Final naming for `service_links` vs. multiple specialized block types (`service_related_links`, etc.).
- Whether long-form sections should support nested media (images, lists) out-of-the-box in TipTap.
- Any automation required to auto-insert default blocks when creating a new service page via JSON.

Once these decisions are confirmed, we can proceed to implement migrations, seed updates, and CMS/editor enhancements per the workflow.
