<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\SitemapController;

class GenerateBlogSitemap extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sitemap:generate-blog {--output= : Optional file path to save the sitemap}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate the blog sitemap XML';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Generating blog sitemap...');

        $controller = new SitemapController();
        $response = $controller->blogSitemap();

        // Get the XML content from the response
        $xml = $response->getContent();

        // If output file is specified, save to file
        if ($output = $this->option('output')) {
            file_put_contents($output, $xml);
            $this->info("Blog sitemap saved to: {$output}");
            $this->info("Total URLs: " . substr_count($xml, '<url>'));
        } else {
            // Otherwise, output to console
            $this->line($xml);
        }

        $this->info('Blog sitemap generated successfully!');
        
        return 0;
    }
}
