<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Models\Page;

class AboutController extends Controller
{
    public function index()
    {
        // Try to load from CMS first
        $cmsPage = Page::where('slug', 'about')
            ->with(['contentBlocks' => function($query) {
                $query->where('is_active', true)->orderBy('order');
            }, 'seo'])
            ->first();

        if ($cmsPage && $cmsPage->contentBlocks->isNotEmpty()) {
            // Use CMS data
            return Inertia::render('About', [
                'page' => $cmsPage,
                'contentBlocks' => $cmsPage->contentBlocks,
                'seoData' => [
                    'title' => $cmsPage->seo->meta_title,
                    'description' => $cmsPage->seo->meta_description,
                    'keywords' => $cmsPage->seo->meta_keywords,
                    'canonicalUrl' => $cmsPage->seo->canonical_url,
                    'ogUrl' => $cmsPage->seo->canonical_url,
                    'ogTitle' => $cmsPage->seo->og_title,
                    'ogDescription' => $cmsPage->seo->og_description,
                    'ogImage' => $cmsPage->seo->og_image,
                    'twitterTitle' => $cmsPage->seo->twitter_title,
                    'twitterDescription' => $cmsPage->seo->twitter_description,
                    'twitterImage' => $cmsPage->seo->twitter_image,
                ],
                'openGraph' => [
                    'title' => $cmsPage->seo->og_title,
                    'description' => $cmsPage->seo->og_description,
                    'image' => $cmsPage->seo->og_image,
                ],
                'structuredData' => $cmsPage->seo->structured_data ?? [],
                'isCMS' => true
            ]);
        }

        // Fallback to static data
        return Inertia::render('About', [
            'seoData' => [
                'title' => 'About Us | Professional Academic Writing Service | Academic Scribe',
                'description' => 'Learn about Academic Scribe - a trusted academic writing service with 500+ expert writers, 50,000+ papers delivered, and 98% customer satisfaction. Professional essay writing, research papers, and dissertation help.',
                'keywords' => 'about academic scribe, professional essay writing service, academic writing company, expert writers, custom essays, research paper help, dissertation writing, assignment assistance, academic support, online writing service',
                'canonicalUrl' => url('/about'),
                'ogUrl' => url('/about'),
            ],
            'isCMS' => false
        ]);
    }
}
