<?php

namespace App\Http\Controllers;

use App\Models\AcademicLevel;
use Illuminate\Http\Request;

class AcademicLevelsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $academicLevels = AcademicLevel::all();
        return inertia('Admin/AcademicLevels/Index', [
            'academicLevels' => $academicLevels,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return inertia('Admin/AcademicLevels/Create');
    }

    /**
     * Store a newly created resource in storage.
     */

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:191|unique:academic_levels',
            'value' => 'required|numeric'
        ]);

        $academicLevel = AcademicLevel::create($validated);

        return redirect()
            ->route('academic-levels.index')
            ->with('message', 'Academic level created successfully');
    }




    /**
     * Display the specified resource.
     */
    public function show(AcademicLevel $academicLevel)
    {
        return inertia('Admin/AcademicLevels/Show', [
            'academicLevel' => $academicLevel,
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AcademicLevel $academicLevel)
    {
        return inertia('Admin/AcademicLevels/Edit', [
            'academicLevel' => $academicLevel,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, AcademicLevel $academicLevel)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:191|unique:academic_levels,name,' . $academicLevel->id,
            'value' => 'required|numeric'
        ]);

        $academicLevel->update($validated);

        return redirect()
            ->route('academic-levels.index')
            ->with('message', 'Academic level updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AcademicLevel $academicLevel)
    {
        $academicLevel->delete();
        return redirect()
            ->route('academic-levels.index')->with('message', 'Academic level deleted successfully');
    }
}
