<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminSetting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ThirdPartyScriptsController extends Controller
{
    /**
     * Display the third party scripts management page.
     */
    public function index()
    {
        $setting = AdminSetting::first() ?? new AdminSetting();

        return Inertia::render('Admin/ThirdPartyScripts/Index', [
            'setting' => [
                // Google Tag Manager settings
                'enable_gtm' => $setting->enable_gtm ?? false,
                'gtm_id' => $setting->gtm_id ?? '',
                'gtm_delay' => $setting->gtm_delay ?? 2000,
                
                // Tawk.to settings
                'enable_tawkto' => $setting->enable_tawkto ?? false,
                'tawkto_property_id' => $setting->tawkto_property_id ?? '',
                'tawkto_widget_id' => $setting->tawkto_widget_id ?? '',
                'tawkto_delay' => $setting->tawkto_delay ?? 5000,
                
                // Comm100 settings
                'enable_comm100' => $setting->enable_comm100 ?? false,
                'comm100_site_id' => $setting->comm100_site_id ?? '',
                'comm100_code_plan' => $setting->comm100_code_plan ?? '',
                'comm100_div_id' => $setting->comm100_div_id ?? '',
                'comm100_delay' => $setting->comm100_delay ?? 5000,
            ],
        ]);
    }

    /**
     * Update the third party scripts settings.
     */
    public function update(Request $request)
    {
        $validated = $request->validate([
            // Google Tag Manager validation
            'enable_gtm' => 'boolean',
            'gtm_id' => 'nullable|string|max:255',
            'gtm_delay' => 'nullable|integer|min:0|max:30000',
            
            // Tawk.to validation
            'enable_tawkto' => 'boolean',
            'tawkto_property_id' => 'nullable|string|max:255',
            'tawkto_widget_id' => 'nullable|string|max:255',
            'tawkto_delay' => 'nullable|integer|min:0|max:30000',
            
            // Comm100 validation
            'enable_comm100' => 'boolean',
            'comm100_site_id' => 'nullable|string|max:255',
            'comm100_code_plan' => 'nullable|string|max:255',
            'comm100_div_id' => 'nullable|string|max:255',
            'comm100_delay' => 'nullable|integer|min:0|max:30000',
        ]);

        $setting = AdminSetting::first();

        if (!$setting) {
            $setting = new AdminSetting();
        }

        // Update all validated fields
        foreach ($validated as $key => $value) {
            $setting->$key = $value;
        }

        $setting->save();

        return redirect()
            ->route('admin.third-party-scripts.index')
            ->with('message', '3rd party scripts settings updated successfully!');
    }
}
