<?php

namespace App\Http\Controllers;

use App\Models\AdminSetting;
use Illuminate\Http\Request;

class AdminSettingController extends Controller
{

    public function show($id)
    {
        $setting = AdminSetting::find($id);
        return inertia('Admin/Settings/Show', ['setting' => $setting]);
    }

    public function edit($id)
    {
        $setting = AdminSetting::find($id);
        return inertia('Admin/Settings/Edit', ['setting' => $setting]);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'writer_fee' => 'required|numeric',
            'writer_deadline' => 'required|numeric',
            'price_per_slide' => 'required|numeric',
            'enable_coupon' => 'boolean',
            'enable_stripe_payment' => 'boolean',
            'questions_test_duration' => 'required|integer|min:1|max:180',
            'essay_test_duration' => 'required|integer|min:1|max:180',
            // Third-party scripts validation
            'enable_gtm' => 'boolean',
            'gtm_id' => 'nullable|string|max:255',
            'gtm_delay' => 'nullable|integer|min:0|max:10000',
            'enable_tawkto' => 'boolean',
            'tawkto_property_id' => 'nullable|string|max:255',
            'tawkto_widget_id' => 'nullable|string|max:255',
            'tawkto_delay' => 'nullable|integer|min:0|max:10000',
            'enable_comm100' => 'boolean',
            'comm100_site_id' => 'nullable|string|max:255',
            'comm100_code_plan' => 'nullable|string|max:255',
            'comm100_div_id' => 'nullable|string|max:255',
            'comm100_delay' => 'nullable|integer|min:0|max:10000',
        ]);

        $setting = AdminSetting::findOrFail($id);
        
        // Ensure only one chat service is enabled at a time
        if (isset($validated['enable_tawkto']) && $validated['enable_tawkto']) {
            $validated['enable_comm100'] = false;
        }
        if (isset($validated['enable_comm100']) && $validated['enable_comm100']) {
            $validated['enable_tawkto'] = false;
        }
        
        $setting->update($validated);

        return redirect()->route('admin.settings.edit', $id)
            ->with('message', 'Settings updated successfully!');
    }

    public function deactivateCoupon($id)
    {
        $setting = AdminSetting::findOrFail($id);
        $setting->update(['enable_coupon' => false]);

        return redirect()->route('admin.settings.show', $id)->with('message', 'Coupon deactivated.');
    }

    public function activateCoupon($id)
    {
        $setting = AdminSetting::findOrFail($id);
        $setting->update(['enable_coupon' => true]);
        return redirect()->route('admin.settings.show', $id)->with('message', 'Coupon Enabled.');
    }

    public function deactivateStripe($id)
    {
        $setting = AdminSetting::findOrFail($id);
        $setting->update(['enable_stripe_payment' => false]);

        return redirect()->route('admin.settings.show', $id)->with('message', 'Stripe Payment deactivated.');
    }

    public function activateStripe($id)
    {
        $setting = AdminSetting::findOrFail($id);
        $setting->update(['enable_stripe_payment' => true]);
        return redirect()->route('admin.settings.show', $id)->with('message', 'Stripe Payment Enabled.');
    }
}
