<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use App\Models\PaperType;
use Illuminate\Http\Request;

class PaperTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $paperTypes = PaperType::paginate(10);

        return Inertia::render('Admin/PaperTypes/Index', [
            'paperTypes' => $paperTypes,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('Admin/PaperTypes/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:paper_types',
            'value' => 'required|numeric',
        ]);
        PaperType::create($validated);
        return redirect()
            ->route('paper-types.index')
            ->with('message', 'Paper type created successfully');
    }



    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PaperType $paperType)
    {
        return Inertia::render('Admin/PaperTypes/Edit', [
            'paperType' => $paperType,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PaperType $paperType)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:paper_types,name,' . $paperType->id,
            'value' => 'required|numeric',
        ]);
        $paperType->update($validated);
        return redirect()
            ->route('paper-types.index')
            ->with('message', 'Paper type updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PaperType $paperType)
    {
        $paperType->delete();
        return redirect()
            ->route('paper-types.index')
            ->with('message', 'Paper type deleted successfully');
    }
}
