<?php

namespace App\Http\Controllers;

use App\Models\Pricing;
use Illuminate\Http\Request;

class UrgenciesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $pricings = Pricing::paginate(5);
        return inertia('Admin/Urgencies/Index', [
            'urgencies' => $pricings,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return inertia('Admin/Urgencies/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'urgency' => 'required|numeric|unique:pricing',
            'value' => 'required|numeric',
            'duration' => 'required|string'
        ]);
        $pricing = Pricing::create($validated);
        return redirect()
            ->route('pricings.index')
            ->with('message', 'Urgency created successfully');
    }



    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Pricing $pricing)
    {
        return inertia('Admin/Urgencies/Edit', [
            'pricing' => $pricing
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Pricing $pricing)
    {
        $validated = $request->validate([
            'urgency' => 'required|numeric',
            'value' => 'required|numeric',
            'duration' => 'required|string'
        ]);
        $pricing->update($validated);
        return redirect()
            ->route('pricings.index')
            ->with('message', 'Urgency updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Pricing $pricing)
    {
        $pricing->delete();
        return redirect()
            ->route('pricings.index')
            ->with('message', 'Urgency deleted successfully');
    }
}
