<?php

namespace App\Http\Controllers;

use Inertia\Inertia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class WriterPageController extends Controller
{
    public function index(Request $request)
    {
        // Cache SEO data for better performance
        $seoData = Cache::remember('writers_seo_data', 3600, function () {
            return [
                'title' => 'Professional Essay Writers for Hire | 847+ Expert Academic Writers | Supreme Freelancers',
                'description' => 'Hire professional essay writers with PhD and Masters degrees. 847+ qualified academic writers available for custom essays, research papers, dissertations, and assignments. Expert writers for students worldwide.',
                'keywords' => 'essay writers for hire, professional essay writers, academic writers for hire, expert dissertation writers, research paper writers, assignment writers, custom essay writers, qualified academic writers, experienced writers, PhD writers, freelance academic writers, college essay writers, university writers, paper writers for students, writing experts, academic writing professionals, hire professional essay writers online, best academic writers for college students, experienced dissertation writers for hire, qualified research paper writers available, expert writers for academic assignments, professional writers with PhD degrees, hire native English academic writers, custom essay writers with guarantees, affordable academic writers for students, reliable essay writers for urgent papers',
                'ogTitle' => 'Professional Essay Writers for Hire | 847+ Expert Academic Writers',
                'ogDescription' => 'Hire qualified essay writers with advanced degrees. Expert academic writers available for custom papers, research, and assignments. Professional writing help for students.',
                'ogImage' => asset('images/writers-og.jpg'),
                'ogUrl' => url('/writers'),
                'twitterTitle' => 'Professional Essay Writers for Hire | Expert Academic Writers',
                'twitterDescription' => 'Hire qualified essay writers with PhD and Masters degrees. 847+ expert academic writers available for custom papers and assignments.',
                'twitterImage' => asset('images/writers-twitter.jpg'),
                'canonicalUrl' => url('/writers'),
                'structuredData' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'WebPage',
                    'name' => 'Professional Essay Writers for Hire',
                    'description' => 'Hire expert academic writers with PhD and Masters degrees for custom essays, research papers, and assignments',
                    'url' => url('/writers'),
                    'mainEntity' => [
                        '@type' => 'Organization',
                        'name' => 'Supreme Freelancers',
                        'description' => 'Professional academic writing service with expert writers',
                        'numberOfEmployees' => 847,
                        'aggregateRating' => [
                            '@type' => 'AggregateRating',
                            'ratingValue' => 4.9,
                            'reviewCount' => 2847,
                            'bestRating' => 5,
                            'worstRating' => 1
                        ]
                    ]
                ]
            ];
        });

        return Inertia::render('Writers', [
            'seoData' => $seoData,
        ]);
    }

    public function browse(Request $request)
    {
        // Browse all writers page
        return Inertia::render('Writers/Browse', [
            'filters' => $request->all(),
        ]);
    }
}
