<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BlogAuthor extends Model
{
    use HasFactory;

    protected $table = 'blog_authors';

    protected $fillable = [
        'name',
        'email',
        'bio',
        'avatar',
        'social_links',
    ];

    protected $casts = [
        'social_links' => 'array',
    ];

    // Relationships
    public function posts(): HasMany
    {
        return $this->hasMany(BlogPost::class, 'author_id');
    }

    public function publishedPosts(): HasMany
    {
        return $this->hasMany(BlogPost::class, 'author_id')->where('status', 'published');
    }

    // Methods
    public function getPostCount()
    {
        return $this->publishedPosts()->count();
    }

    public function getAvatarUrl()
    {
        return $this->avatar ? asset('storage/' . $this->avatar) : null;
    }
}
