<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class BlogTag extends Model
{
    use HasFactory;

    protected $table = 'blog_tags';

    protected $fillable = [
        'name',
        'slug',
    ];

    // Relationships
    public function posts(): BelongsToMany
    {
        return $this->belongsToMany(BlogPost::class, 'blog_post_tags', 'tag_id', 'blog_post_id')
            ->withTimestamps();
    }

    public function publishedPosts(): BelongsToMany
    {
        return $this->belongsToMany(BlogPost::class, 'blog_post_tags', 'tag_id', 'blog_post_id')
            ->where('status', 'published')
            ->withTimestamps();
    }

    // Accessors
    public function getRouteKeyName()
    {
        return 'slug';
    }

    // Methods
    public function getPostCount()
    {
        return $this->publishedPosts()->count();
    }
}
