<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Language extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'code'];

    /**
     * Get the writer profiles for the language.
     */
    public function writerProfiles()
    {
        return $this->belongsToMany(WriterProfile::class, 'writer_languages');
    }
}
