<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NotificationPreference extends Model
{
    protected $fillable = [
        'user_id',
        // Order notifications
        'order_status_updates',
        'order_status_updates_email',
        'order_status_updates_in_app',
        'writer_assignment',
        'writer_assignment_email',
        'writer_assignment_in_app',
        'new_bids',
        'new_bids_email',
        'new_bids_in_app',
        'deadline_reminders',
        'deadline_reminders_email',
        'deadline_reminders_in_app',
        'order_completion',
        'order_completion_email',
        'order_completion_in_app',
        'revision_requests',
        'revision_requests_email',
        'revision_requests_in_app',
        // Payment notifications
        'payment_confirmations',
        'payment_confirmations_email',
        'payment_confirmations_in_app',
        'payment_failures',
        'payment_failures_email',
        'payment_failures_in_app',
        'refunds',
        'refunds_email',
        'refunds_in_app',
        'invoice_ready',
        'invoice_ready_email',
        'invoice_ready_in_app',
        // Communication notifications
        'new_messages',
        'new_messages_email',
        'new_messages_in_app',
        'writer_questions',
        'writer_questions_email',
        'writer_questions_in_app',
        // System notifications
        'system_announcements',
        'system_announcements_email',
        'system_announcements_in_app',
        'promotional_emails',
        'coupon_alerts',
        'coupon_alerts_email',
        'coupon_alerts_in_app',
    ];

    protected $casts = [
        'order_status_updates' => 'boolean',
        'order_status_updates_email' => 'boolean',
        'order_status_updates_in_app' => 'boolean',
        'writer_assignment' => 'boolean',
        'writer_assignment_email' => 'boolean',
        'writer_assignment_in_app' => 'boolean',
        'new_bids' => 'boolean',
        'new_bids_email' => 'boolean',
        'new_bids_in_app' => 'boolean',
        'deadline_reminders' => 'boolean',
        'deadline_reminders_email' => 'boolean',
        'deadline_reminders_in_app' => 'boolean',
        'order_completion' => 'boolean',
        'order_completion_email' => 'boolean',
        'order_completion_in_app' => 'boolean',
        'revision_requests' => 'boolean',
        'revision_requests_email' => 'boolean',
        'revision_requests_in_app' => 'boolean',
        'payment_confirmations' => 'boolean',
        'payment_confirmations_email' => 'boolean',
        'payment_confirmations_in_app' => 'boolean',
        'payment_failures' => 'boolean',
        'payment_failures_email' => 'boolean',
        'payment_failures_in_app' => 'boolean',
        'refunds' => 'boolean',
        'refunds_email' => 'boolean',
        'refunds_in_app' => 'boolean',
        'invoice_ready' => 'boolean',
        'invoice_ready_email' => 'boolean',
        'invoice_ready_in_app' => 'boolean',
        'new_messages' => 'boolean',
        'new_messages_email' => 'boolean',
        'new_messages_in_app' => 'boolean',
        'writer_questions' => 'boolean',
        'writer_questions_email' => 'boolean',
        'writer_questions_in_app' => 'boolean',
        'system_announcements' => 'boolean',
        'system_announcements_email' => 'boolean',
        'system_announcements_in_app' => 'boolean',
        'promotional_emails' => 'boolean',
        'coupon_alerts' => 'boolean',
        'coupon_alerts_email' => 'boolean',
        'coupon_alerts_in_app' => 'boolean',
    ];

    /**
     * Get the user that owns the notification preferences.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get or create notification preferences for a user.
     */
    public static function getOrCreateForUser(int $userId): self
    {
        return static::firstOrCreate(['user_id' => $userId]);
    }
}