<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    protected $fillable = [
        'slug',
        'title',
        'page_type',
        'status',
        'parent_id',
        'template',
        'seo_priority',
        'published_at',
    ];

    protected $casts = [
        'published_at' => 'datetime',
        'seo_priority' => 'integer',
    ];

    public function contentBlocks()
    {
        return $this->hasMany(PageContent::class)->orderBy('order');
    }

    public function seo()
    {
        return $this->hasOne(PageSeo::class);
    }

    public function media()
    {
        return $this->hasMany(PageMedia::class);
    }

    public function relationships()
    {
        return $this->hasMany(PageRelationship::class);
    }

    public function parent()
    {
        return $this->belongsTo(Page::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Page::class, 'parent_id');
    }
}
