<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageMedia extends Model
{
    protected $table = 'page_media';
    
    protected $fillable = [
        'page_id',
        'media_type',
        'file_path',
        'alt_text',
        'title',
        'caption',
        'usage_context',
        'optimization_settings',
        'is_optimized',
        'file_size',
    ];

    protected $casts = [
        'optimization_settings' => 'array',
        'is_optimized' => 'boolean',
    ];

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
