<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageRelationship extends Model
{
    protected $fillable = [
        'page_id',
        'related_page_id',
        'relationship_type',
        'link_text',
        'link_context',
        'order',
    ];

    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    public function relatedPage()
    {
        return $this->belongsTo(Page::class, 'related_page_id');
    }
}
