<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageSeo extends Model
{
    protected $table = 'page_seo';
    
    protected $fillable = [
        'page_id',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'canonical_url',
        'robots',
        'language',
        'og_title',
        'og_description',
        'og_image',
        'og_image_alt',
        'og_type',
        'og_url',
        'og_site_name',
        'og_locale',
        'twitter_card',
        'twitter_site',
        'twitter_creator',
        'twitter_title',
        'twitter_description',
        'twitter_image',
        'twitter_image_alt',
        'structured_data',
    ];

    protected $casts = [
        'structured_data' => 'array',
    ];

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
