<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WriterCitationStyle extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description'];

    /**
     * Get the writer profiles for the citation style.
     */
    public function writerProfiles()
    {
        return $this->belongsToMany(WriterProfile::class, 'writer_citation_style');
    }
}
