<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WriterEssay extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'topic_id',
        'content',
        'status',
        'feedback',
        'reviewed_at',
        'reviewed_by',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'reviewed_at' => 'datetime',
    ];

    /**
     * Get the writer that owns the essay.
     */
    public function writer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the reviewer that reviewed the essay.
     */
    public function reviewer()
    {
        return $this->belongsTo(User::class, 'reviewed_by');
    }

    /**
     * Get the topic for this essay.
     */
    public function topic()
    {
        return $this->belongsTo(EssayTopic::class, 'topic_id');
    }

    /**
     * Scope a query to only include pending essays.
     */
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    /**
     * Scope a query to only include approved essays.
     */
    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    /**
     * Scope a query to only include rejected essays.
     */
    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }
}
