<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WriterLevel extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'min_experience_years', 'hourly_rate_min', 'hourly_rate_max'];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'min_experience_years' => 'integer',
        'hourly_rate_min' => 'decimal:2',
        'hourly_rate_max' => 'decimal:2',
    ];

    /**
     * Get the writer profiles for the writer level.
     */
    public function writerProfiles()
    {
        return $this->hasMany(WriterProfile::class);
    }
}
