<?php

namespace App\Policies;

use App\Models\Payment;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PaymentPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view payment analytics.
     *
     * @param  \App\Models\User  $user
     * @return bool
     */
    public function viewPaymentAnalytics(User $user)
    {
        return $user->isAdmin() || $user->user_type === 'super_admin';
    }

    /**
     * Determine whether the user can view any payments.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        return $user->isAdmin() || $user->user_type === 'super_admin';
    }
    /**
     * Determine whether the user can view the payment.
     *
     * @param \App\Models\User $user
     * @param \App\Models\Payment $payment
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, Payment $payment)
    {
        // Admin can view any payment
        if ($user->isSuperAdmin() || $user->isAdmin()) {
            return true;
        }

        // Client can view their own payment
        if ($user->isClient() && $payment->order && $payment->order->user_id === $user->id) {
            return true;
        }

        return false;
    }


    /**
     * Determine whether the user can export payments.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function export(User $user)
    {
        return $user->isAdmin() || $user->isSuperAdmin();
    }

    /**
     * Determine whether the user can refund the payment.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Payment  $payment
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function refund(User $user, Payment $payment)
    {
        // Only super admin users can issue refunds
        return $user->isSuperAdmin();
    }
}
