<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Image Optimization Settings
    |--------------------------------------------------------------------------
    |
    | Configure image optimization behavior, formats, and quality settings
    | for different types of images used throughout the application.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Default Settings
    |--------------------------------------------------------------------------
    */
    'default_quality' => env('IMAGE_DEFAULT_QUALITY', 85),
    'default_format' => env('IMAGE_DEFAULT_FORMAT', 'webp'),
    'enable_avif' => env('IMAGE_ENABLE_AVIF', true),
    'enable_webp' => env('IMAGE_ENABLE_WEBP', true),
    'progressive_jpeg' => env('IMAGE_PROGRESSIVE_JPEG', true),

    /*
    |--------------------------------------------------------------------------
    | Conversion Presets
    |--------------------------------------------------------------------------
    |
    | Define different image conversion presets for various use cases.
    | Each preset can have multiple format outputs with specific settings.
    |
    */
    'presets' => [
        'hero' => [
            'description' => 'Large hero images for landing pages and headers',
            'formats' => [
                'avif' => [
                    'width' => 1920,
                    'height' => 1080,
                    'quality' => 75,
                    'progressive' => true,
                ],
                'webp' => [
                    'width' => 1920,
                    'height' => 1080,
                    'quality' => 85,
                    'progressive' => true,
                ],
                'fallback' => [
                    'width' => 1920,
                    'height' => 1080,
                    'quality' => 90,
                    'format' => 'jpg',
                    'progressive' => true,
                ],
            ],
            'responsive_sizes' => [
                'mobile' => ['width' => 768, 'height' => 432],
                'tablet' => ['width' => 1024, 'height' => 576],
                'desktop' => ['width' => 1920, 'height' => 1080],
            ],
        ],

        'blog' => [
            'description' => 'Blog post featured images and content images',
            'formats' => [
                'avif' => [
                    'width' => 1200,
                    'height' => 675,
                    'quality' => 70,
                    'progressive' => true,
                ],
                'webp' => [
                    'width' => 1200,
                    'height' => 675,
                    'quality' => 80,
                    'progressive' => true,
                ],
                'fallback' => [
                    'width' => 1200,
                    'height' => 675,
                    'quality' => 85,
                    'format' => 'jpg',
                    'progressive' => true,
                ],
            ],
            'responsive_sizes' => [
                'mobile' => ['width' => 400, 'height' => 225],
                'tablet' => ['width' => 768, 'height' => 432],
                'desktop' => ['width' => 1200, 'height' => 675],
            ],
        ],

        'service' => [
            'description' => 'Service page images and feature illustrations',
            'formats' => [
                'avif' => [
                    'width' => 800,
                    'height' => 600,
                    'quality' => 70,
                    'progressive' => true,
                ],
                'webp' => [
                    'width' => 800,
                    'height' => 600,
                    'quality' => 80,
                    'progressive' => true,
                ],
                'fallback' => [
                    'width' => 800,
                    'height' => 600,
                    'quality' => 85,
                    'format' => 'jpg',
                    'progressive' => true,
                ],
            ],
            'responsive_sizes' => [
                'mobile' => ['width' => 320, 'height' => 240],
                'tablet' => ['width' => 600, 'height' => 450],
                'desktop' => ['width' => 800, 'height' => 600],
            ],
        ],

        'thumbnail' => [
            'description' => 'Small thumbnail images for cards and previews',
            'formats' => [
                'avif' => [
                    'width' => 400,
                    'height' => 300,
                    'quality' => 65,
                    'progressive' => false,
                ],
                'webp' => [
                    'width' => 400,
                    'height' => 300,
                    'quality' => 75,
                    'progressive' => false,
                ],
                'fallback' => [
                    'width' => 400,
                    'height' => 300,
                    'quality' => 80,
                    'format' => 'jpg',
                    'progressive' => false,
                ],
            ],
            'responsive_sizes' => [
                'small' => ['width' => 200, 'height' => 150],
                'medium' => ['width' => 300, 'height' => 225],
                'large' => ['width' => 400, 'height' => 300],
            ],
        ],

        'avatar' => [
            'description' => 'User avatars and profile pictures',
            'formats' => [
                'avif' => [
                    'width' => 200,
                    'height' => 200,
                    'quality' => 70,
                    'progressive' => false,
                ],
                'webp' => [
                    'width' => 200,
                    'height' => 200,
                    'quality' => 80,
                    'progressive' => false,
                ],
                'fallback' => [
                    'width' => 200,
                    'height' => 200,
                    'quality' => 85,
                    'format' => 'jpg',
                    'progressive' => false,
                ],
            ],
            'responsive_sizes' => [
                'small' => ['width' => 50, 'height' => 50],
                'medium' => ['width' => 100, 'height' => 100],
                'large' => ['width' => 200, 'height' => 200],
            ],
        ],

        'logo' => [
            'description' => 'Logos and brand images (preserves transparency)',
            'formats' => [
                'webp' => [
                    'width' => 300,
                    'height' => 120,
                    'quality' => 90,
                    'progressive' => false,
                ],
                'fallback' => [
                    'width' => 300,
                    'height' => 120,
                    'quality' => 95,
                    'format' => 'png',
                    'progressive' => false,
                ],
            ],
            'responsive_sizes' => [
                'small' => ['width' => 150, 'height' => 60],
                'medium' => ['width' => 225, 'height' => 90],
                'large' => ['width' => 300, 'height' => 120],
            ],
        ],

        'icon' => [
            'description' => 'Small icons and UI elements',
            'formats' => [
                'webp' => [
                    'width' => 64,
                    'height' => 64,
                    'quality' => 85,
                    'progressive' => false,
                ],
                'fallback' => [
                    'width' => 64,
                    'height' => 64,
                    'quality' => 90,
                    'format' => 'png',
                    'progressive' => false,
                ],
            ],
            'responsive_sizes' => [
                'small' => ['width' => 24, 'height' => 24],
                'medium' => ['width' => 48, 'height' => 48],
                'large' => ['width' => 64, 'height' => 64],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | File Processing Settings
    |--------------------------------------------------------------------------
    */
    'processing' => [
        'max_file_size' => env('IMAGE_MAX_FILE_SIZE', 10 * 1024 * 1024), // 10MB
        'allowed_extensions' => ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'tiff', 'webp'],
        'memory_limit' => env('IMAGE_MEMORY_LIMIT', '256M'),
        'timeout' => env('IMAGE_TIMEOUT', 60), // seconds
        'concurrent_jobs' => env('IMAGE_CONCURRENT_JOBS', 3),
    ],

    /*
    |--------------------------------------------------------------------------
    | Storage Settings
    |--------------------------------------------------------------------------
    */
    'storage' => [
        'disk' => env('IMAGE_STORAGE_DISK', 'public'),
        'path_prefix' => env('IMAGE_PATH_PREFIX', 'images'),
        'organize_by_date' => env('IMAGE_ORGANIZE_BY_DATE', false),
        'preserve_original' => env('IMAGE_PRESERVE_ORIGINAL', true),
        'cleanup_originals' => env('IMAGE_CLEANUP_ORIGINALS', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Optimization Settings
    |--------------------------------------------------------------------------
    */
    'optimization' => [
        'strip_metadata' => env('IMAGE_STRIP_METADATA', true),
        'auto_orient' => env('IMAGE_AUTO_ORIENT', true),
        'sharpen' => env('IMAGE_SHARPEN', false),
        'blur_threshold' => env('IMAGE_BLUR_THRESHOLD', 0.5),
        'compression_level' => env('IMAGE_COMPRESSION_LEVEL', 9), // PNG compression
    ],

    /*
    |--------------------------------------------------------------------------
    | Responsive Images Settings
    |--------------------------------------------------------------------------
    */
    'responsive' => [
        'generate_srcset' => env('IMAGE_GENERATE_SRCSET', true),
        'breakpoints' => [
            'mobile' => 480,
            'tablet' => 768,
            'desktop' => 1024,
            'large' => 1440,
            'xlarge' => 1920,
        ],
        'sizes_attribute' => env('IMAGE_SIZES_ATTRIBUTE', '(max-width: 768px) 100vw, (max-width: 1024px) 50vw, 33vw'),
        'lazy_loading' => env('IMAGE_LAZY_LOADING', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Performance Settings
    |--------------------------------------------------------------------------
    */
    'performance' => [
        'cache_enabled' => env('IMAGE_CACHE_ENABLED', true),
        'cache_duration' => env('IMAGE_CACHE_DURATION', 86400), // 24 hours
        'queue_processing' => env('IMAGE_QUEUE_PROCESSING', false),
        'queue_connection' => env('IMAGE_QUEUE_CONNECTION', 'default'),
        'batch_size' => env('IMAGE_BATCH_SIZE', 10),
    ],

    /*
    |--------------------------------------------------------------------------
    | CDN Settings
    |--------------------------------------------------------------------------
    */
    'cdn' => [
        'enabled' => env('IMAGE_CDN_ENABLED', false),
        'base_url' => env('IMAGE_CDN_BASE_URL', ''),
        'cache_control' => env('IMAGE_CDN_CACHE_CONTROL', 'public, max-age=31536000'), // 1 year
        'auto_upload' => env('IMAGE_CDN_AUTO_UPLOAD', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Watermark Settings
    |--------------------------------------------------------------------------
    */
    'watermark' => [
        'enabled' => env('IMAGE_WATERMARK_ENABLED', false),
        'image_path' => env('IMAGE_WATERMARK_PATH', 'images/watermark.png'),
        'position' => env('IMAGE_WATERMARK_POSITION', 'bottom-right'), // top-left, top-right, bottom-left, bottom-right, center
        'opacity' => env('IMAGE_WATERMARK_OPACITY', 50), // 0-100
        'margin' => env('IMAGE_WATERMARK_MARGIN', 10), // pixels
        'apply_to_presets' => ['hero', 'blog', 'service'], // Only apply to specific presets
    ],

    /*
    |--------------------------------------------------------------------------
    | Validation Settings
    |--------------------------------------------------------------------------
    */
    'validation' => [
        'min_width' => env('IMAGE_MIN_WIDTH', 100),
        'min_height' => env('IMAGE_MIN_HEIGHT', 100),
        'max_width' => env('IMAGE_MAX_WIDTH', 4000),
        'max_height' => env('IMAGE_MAX_HEIGHT', 4000),
        'aspect_ratio_tolerance' => env('IMAGE_ASPECT_RATIO_TOLERANCE', 0.1),
        'require_alt_text' => env('IMAGE_REQUIRE_ALT_TEXT', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | SEO Settings
    |--------------------------------------------------------------------------
    */
    'seo' => [
        'auto_generate_alt' => env('IMAGE_AUTO_GENERATE_ALT', false),
        'filename_optimization' => env('IMAGE_FILENAME_OPTIMIZATION', true),
        'structured_data' => env('IMAGE_STRUCTURED_DATA', true),
        'social_media_sizes' => [
            'og_image' => ['width' => 1200, 'height' => 630],
            'twitter_card' => ['width' => 1200, 'height' => 600],
            'linkedin_share' => ['width' => 1200, 'height' => 627],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Development Settings
    |--------------------------------------------------------------------------
    */
    'development' => [
        'debug_mode' => env('IMAGE_DEBUG_MODE', false),
        'log_processing' => env('IMAGE_LOG_PROCESSING', false),
        'show_processing_time' => env('IMAGE_SHOW_PROCESSING_TIME', false),
        'generate_placeholder' => env('IMAGE_GENERATE_PLACEHOLDER', true),
        'placeholder_color' => env('IMAGE_PLACEHOLDER_COLOR', '#f3f4f6'),
    ],
];
