<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Messaging Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for the messaging system,
    | including automation rules and thresholds.
    |
    */

    'automation' => [
        /*
        |--------------------------------------------------------------------------
        | Auto-Resolution Settings
        |--------------------------------------------------------------------------
        |
        | Configure when conversations should be automatically resolved due to
        | inactivity. Set to null to disable auto-resolution.
        |
        */
        'auto_resolve_after_days' => env('MESSAGING_AUTO_RESOLVE_DAYS', 7),
        'auto_resolve_enabled' => env('MESSAGING_AUTO_RESOLVE_ENABLED', true),
        
        /*
        |--------------------------------------------------------------------------
        | Auto-Archive Settings
        |--------------------------------------------------------------------------
        |
        | Configure when resolved conversations should be automatically archived.
        | Set to null to disable auto-archiving.
        |
        */
        'auto_archive_after_days' => env('MESSAGING_AUTO_ARCHIVE_DAYS', 30),
        'auto_archive_enabled' => env('MESSAGING_AUTO_ARCHIVE_ENABLED', true),
        
        /*
        |--------------------------------------------------------------------------
        | Grace Period Settings
        |--------------------------------------------------------------------------
        |
        | How long users can reopen resolved conversations before they're archived.
        |
        */
        'reopen_grace_period_hours' => env('MESSAGING_REOPEN_GRACE_HOURS', 48),
        
        /*
        |--------------------------------------------------------------------------
        | Notification Settings
        |--------------------------------------------------------------------------
        |
        | Configure when to send warning notifications before auto-actions.
        |
        */
        'warning_before_auto_resolve_days' => env('MESSAGING_WARNING_RESOLVE_DAYS', 1),
        'warning_before_auto_archive_days' => env('MESSAGING_WARNING_ARCHIVE_DAYS', 3),
    ],

    'notifications' => [
        /*
        |--------------------------------------------------------------------------
        | Email Notifications
        |--------------------------------------------------------------------------
        |
        | Configure which events should trigger email notifications.
        |
        */
        'enabled' => env('MESSAGING_NOTIFICATIONS_ENABLED', true),
        
        'events' => [
            'conversation_resolved' => env('MESSAGING_NOTIFY_RESOLVED', true),
            'conversation_reopened' => env('MESSAGING_NOTIFY_REOPENED', true),
            'conversation_escalated' => env('MESSAGING_NOTIFY_ESCALATED', true),
            'conversation_archived' => env('MESSAGING_NOTIFY_ARCHIVED', false),
            'auto_resolve_warning' => env('MESSAGING_NOTIFY_AUTO_RESOLVE_WARNING', true),
            'auto_archive_warning' => env('MESSAGING_NOTIFY_AUTO_ARCHIVE_WARNING', true),
        ],
        
        /*
        |--------------------------------------------------------------------------
        | Admin Notification Settings
        |--------------------------------------------------------------------------
        |
        | Configure notifications specifically for administrators.
        |
        */
        'admin_notifications' => [
            'daily_summary' => env('MESSAGING_ADMIN_DAILY_SUMMARY', true),
            'escalated_conversations' => env('MESSAGING_ADMIN_ESCALATED_NOTIFY', true),
        ],
    ],

    'analytics' => [
        /*
        |--------------------------------------------------------------------------
        | Analytics Settings
        |--------------------------------------------------------------------------
        |
        | Configure analytics and reporting features.
        |
        */
        'enabled' => env('MESSAGING_ANALYTICS_ENABLED', true),
        'retention_days' => env('MESSAGING_ANALYTICS_RETENTION_DAYS', 365),
        
        /*
        |--------------------------------------------------------------------------
        | Export Settings
        |--------------------------------------------------------------------------
        |
        | Configure conversation export functionality.
        |
        */
        'export_enabled' => env('MESSAGING_EXPORT_ENABLED', true),
        'export_formats' => ['csv', 'json', 'pdf'],
        'max_export_conversations' => env('MESSAGING_MAX_EXPORT', 1000),
    ],
];