<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Notification Preferences Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the default notification preferences for different
    | user types and notification events.
    |
    */

    'defaults' => [
        'client' => [
            'revision_requested' => ['database', 'mail'],
            'revision_started' => ['database', 'mail'],
            'revision_completed' => ['database', 'mail'],
            'revision_escalated' => ['database', 'mail'],
            'order_status_changed' => ['database', 'mail'],
            'payment_processed' => ['database', 'mail'],
            'work_submitted' => ['database', 'mail'],
        ],
        'writer' => [
            'revision_assigned' => ['database', 'mail'],
            'revision_started' => ['database'],
            'revision_completed' => ['database'],
            'revision_quality_assessed' => ['database', 'mail'],
            'revision_rejected' => ['database', 'mail'],
            'revision_escalated' => ['database', 'mail'],
            'payment_processed' => ['database', 'mail'],
            'fine_applied' => ['database', 'mail'],
            'writer_started_working' => ['database', 'mail'],
            'writer_work_submitted' => ['database', 'mail'],
        ],
        'admin' => [
            'revision_requested' => ['database', 'mail'],
            'revision_escalated' => ['database', 'mail'],
            'payment_issue' => ['database', 'mail'],
            'quality_alert' => ['database', 'mail'],
            'system_alert' => ['database', 'mail'],
            'writer_started_working_admin' => ['database', 'mail'],
            'work_submitted_admin' => ['database', 'mail'],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Available Notification Channels
    |--------------------------------------------------------------------------
    |
    | List of all available notification channels that users can choose from.
    |
    */
    'channels' => [
        'database' => [
            'name' => 'In-App Notifications',
            'description' => 'Receive notifications within the application',
            'icon' => 'bell',
        ],
        'mail' => [
            'name' => 'Email Notifications',
            'description' => 'Receive notifications via email',
            'icon' => 'mail',
        ],
        'sms' => [
            'name' => 'SMS Notifications',
            'description' => 'Receive notifications via text message',
            'enabled' => false, // Disabled by default
            'icon' => 'message-circle',
        ],
        'push' => [
            'name' => 'Push Notifications',
            'description' => 'Receive notifications via browser push',
            'enabled' => false, // Disabled by default
            'icon' => 'smartphone',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Notification Event Descriptions
    |--------------------------------------------------------------------------
    |
    | Human-readable descriptions for each notification event type.
    |
    */
    'events' => [
        'revision_requested' => [
            'name' => 'Revision Requested',
            'description' => 'When a client requests a revision for their order',
            'category' => 'revisions',
        ],
        'revision_started' => [
            'name' => 'Revision Started',
            'description' => 'When a writer begins working on a revision',
            'category' => 'revisions',
        ],
        'revision_completed' => [
            'name' => 'Revision Completed',
            'description' => 'When a writer completes a revision',
            'category' => 'revisions',
        ],
        'revision_quality_assessed' => [
            'name' => 'Quality Assessment',
            'description' => 'When your revision quality is assessed and payment impact calculated',
            'category' => 'revisions',
        ],
        'revision_rejected' => [
            'name' => 'Revision Rejected',
            'description' => 'When your revision is rejected and requires additional work',
            'category' => 'revisions',
        ],
        'revision_assigned' => [
            'name' => 'Revision Assigned',
            'description' => 'When a revision is assigned to you',
            'category' => 'revisions',
        ],
        'revision_escalated' => [
            'name' => 'Revision Escalated',
            'description' => 'When a revision is escalated due to delays or issues',
            'category' => 'revisions',
        ],
        'order_status_changed' => [
            'name' => 'Order Status Changed',
            'description' => 'When the status of your order changes',
            'category' => 'orders',
        ],
        'payment_processed' => [
            'name' => 'Payment Processed',
            'description' => 'When a payment is processed for your order',
            'category' => 'payments',
        ],
        'fine_applied' => [
            'name' => 'Fine Applied',
            'description' => 'When a fine is applied to your account',
            'category' => 'payments',
        ],
        'payment_issue' => [
            'name' => 'Payment Issue',
            'description' => 'When there is an issue with a payment',
            'category' => 'payments',
        ],
        'quality_alert' => [
            'name' => 'Quality Alert',
            'description' => 'When there is a quality-related alert',
            'category' => 'quality',
        ],
        'system_alert' => [
            'name' => 'System Alert',
            'description' => 'Important system-wide notifications',
            'category' => 'system',
        ],
        'writer_started_working_admin' => [
            'name' => 'Writer Started Working',
            'description' => 'When a writer starts working on an assigned order',
            'category' => 'orders',
        ],
        'work_submitted_admin' => [
            'name' => 'Work Submitted for Review',
            'description' => 'When a writer submits completed work for admin review',
            'category' => 'orders',
        ],
        'work_submitted' => [
            'name' => 'Work Submitted',
            'description' => 'When your writer submits completed work for your order',
            'category' => 'orders',
        ],
        'writer_started_working' => [
            'name' => 'Work Started Successfully',
            'description' => 'When you successfully start working on an assigned order',
            'category' => 'orders',
        ],
        'writer_work_submitted' => [
            'name' => 'Work Submitted Successfully',
            'description' => 'When you successfully submit your completed work for review',
            'category' => 'orders',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Notification Frequency Options
    |--------------------------------------------------------------------------
    |
    | Available frequency options for notifications.
    |
    */
    'frequencies' => [
        'immediate' => [
            'name' => 'Immediate',
            'description' => 'Receive notifications immediately',
            'value' => 0,
        ],
        'hourly' => [
            'name' => 'Hourly',
            'description' => 'Receive notifications once per hour',
            'value' => 3600,
        ],
        'daily' => [
            'name' => 'Daily',
            'description' => 'Receive notifications once per day',
            'value' => 86400,
        ],
        'weekly' => [
            'name' => 'Weekly',
            'description' => 'Receive notifications once per week',
            'value' => 604800,
        ],
    ],
]; 