<?php

return [
    /*
    |--------------------------------------------------------------------------
    | PayPal Direct Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration for PayPal Direct (Standard) payments.
    | These settings are used as fallbacks if not configured in the database.
    |
    */

    'mode' => env('PAYPAL_DIRECT_MODE', 'sandbox'),

    'sandbox' => [
        'business_email' => env('PAYPAL_DIRECT_SANDBOX_EMAIL'),
        'form_action' => 'https://www.sandbox.paypal.com/cgi-bin/webscr',
        'ipn_verify' => 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr',
    ],

    'live' => [
        'business_email' => env('PAYPAL_DIRECT_BUSINESS_EMAIL'),
        'form_action' => 'https://www.paypal.com/cgi-bin/webscr',
        'ipn_verify' => 'https://ipnpb.paypal.com/cgi-bin/webscr',
    ],

    'urls' => [
        'return' => env('PAYPAL_DIRECT_RETURN_URL'),
        'cancel' => env('PAYPAL_DIRECT_CANCEL_URL'),
        'notify' => env('PAYPAL_DIRECT_NOTIFY_URL'),
    ],

    'security' => [
        'token_expiry_hours' => env('PAYPAL_DIRECT_TOKEN_EXPIRY_HOURS', 24),
        'hmac_algorithm' => env('PAYPAL_DIRECT_HMAC_ALGORITHM', 'sha256'),
    ],
]; 