<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Revision System Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration options for the order revision system
    | including limits, penalties, and workflow settings.
    |
    */

    // Maximum number of revisions allowed per order
    'max_per_order' => env('REVISION_MAX_PER_ORDER', 3),

    // Default revision due date (hours from creation)
    'default_due_hours' => env('REVISION_DEFAULT_DUE_HOURS', 48),

    // Escalation threshold (hours overdue before escalation)
    'escalation_threshold_hours' => env('REVISION_ESCALATION_THRESHOLD', 24),

    // Quality rating thresholds
    'quality_thresholds' => [
        'excellent' => 5, // 5-star rating gets bonus
        'good' => 4,      // 4-star rating is acceptable
        'poor' => 2,      // 2-star and below gets penalty
    ],

    // Payment impact settings
    'payment_impact' => [
        'quality_bonus' => env('REVISION_QUALITY_BONUS', 5.00), // Bonus for excellent quality
        'quality_penalty' => env('REVISION_QUALITY_PENALTY', 10.00), // Penalty for poor quality
        'delay_penalty_per_hour' => env('REVISION_DELAY_PENALTY_PER_HOUR', 0.50), // Penalty per hour overdue
    ],

    // Revision types and their descriptions
    'types' => [
        'quality' => 'Content quality issues (grammar, clarity, depth)',
        'requirements' => 'Missing or incorrect requirements implementation',
        'formatting' => 'Formatting, structure, or style issues',
        'plagiarism' => 'Plagiarism or originality concerns',
        'deadline' => 'Missed deadline or timing issues',
        'communication' => 'Communication or understanding issues',
        'other' => 'Other issues not covered above',
    ],

    // Status workflow
    'status_workflow' => [
        'requested' => 'Revision has been requested',
        'in_progress' => 'Writer is working on the revision',
        'completed' => 'Revision has been completed',
        'rejected' => 'Revision was rejected',
        'escalated' => 'Revision has been escalated for admin attention',
    ],

    // Auto-escalation settings
    'auto_escalation' => [
        'enabled' => env('REVISION_AUTO_ESCALATION', true),
        'check_interval_hours' => env('REVISION_ESCALATION_CHECK_INTERVAL', 6),
    ],

    // Notification settings
    'notifications' => [
        'writer_assignment' => true,
        'escalation' => true,
        'overdue_reminder' => true,
        'completion' => true,
    ],

    // Performance tracking
    'performance_tracking' => [
        'track_writer_performance' => true,
        'track_revision_frequency' => true,
        'track_quality_ratings' => true,
        'track_completion_times' => true,
    ],
]; 