<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Order;

class OrderFactory extends Factory
{
    protected $model = Order::class;

    public function definition()
    {
        return [
            'order_number' => $this->faker->unique()->numberBetween(59710, 60000),
            'user_id' => $this->faker->randomElement([2, 7, 8, 10, 12, 13, 16, 23, 25]),
            'title' => $this->faker->sentence(6),
            'type_of_paper' => $this->faker->word(),
            'subject' => $this->faker->word(),
            'academic_level' => $this->faker->randomElement(['High School', 'Undergraduate', 'Master', 'PhD']),
            'urgency' => $this->faker->randomElement(['6 hours', '12 hours', '1 day', '3 days', '7 days']),
            'pages' => $this->faker->numberBetween(1, 10),
            'instructions' => $this->faker->paragraph(),
            'styles' => $this->faker->randomElement(['APA', 'MLA', 'Chicago', 'Harvard']),
            'dateposted' => now(),
            'deadline' => $this->faker->dateTimeBetween('+1 day', '+30 days'),
            'client_timezone' => $this->faker->timezone(),
            'sources' => $this->faker->numberBetween(1, 10),
            'order_amount' => $this->faker->randomFloat(2, 10, 500),
            'net_amount' => $this->faker->randomFloat(2, 10, 500),
            'discount' => 0,
            'coupon' => null,
            'payment_status' => $this->faker->randomElement(['paid', 'pending']),
            'order_status' => $this->faker->randomElement(['pending', 'in progress', 'completed', 'cancelled']),
            'powerpoint_slides' => null,
            'spacing' => $this->faker->randomElement(['single', 'double']),
            'order_revision' => null,
            'payment_transaction_id' => null,
            'payment_method' => null,
            'payment_date' => null,
        ];
    }
}
