<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdminSettingsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admin_settings', function (Blueprint $table) {
            $table->id();
            $table->decimal('writer_fee', 8, 2)->default(4.00);
            $table->decimal('writer_deadline', 10, 2);
            $table->boolean('enable_coupon')->default(0);
            $table->decimal('price_per_slide', 8, 2)->default(4.00);
            $table->boolean('enable_stripe_payment')->default(0);
            $table->integer('questions_test_duration')->default(45);
            $table->integer('essay_test_duration')->default(30);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_settings');
    }
}
