<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationPreferencesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_preferences', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            
            // Order notifications
            $table->boolean('order_status_updates')->default(true);
            $table->boolean('order_status_updates_email')->default(true);
            $table->boolean('order_status_updates_in_app')->default(true);
            
            $table->boolean('writer_assignment')->default(true);
            $table->boolean('writer_assignment_email')->default(true);
            $table->boolean('writer_assignment_in_app')->default(true);
            
            $table->boolean('new_bids')->default(true);
            $table->boolean('new_bids_email')->default(true);
            $table->boolean('new_bids_in_app')->default(true);
            
            $table->boolean('deadline_reminders')->default(true);
            $table->boolean('deadline_reminders_email')->default(true);
            $table->boolean('deadline_reminders_in_app')->default(true);
            
            $table->boolean('order_completion')->default(true);
            $table->boolean('order_completion_email')->default(true);
            $table->boolean('order_completion_in_app')->default(true);
            
            $table->boolean('revision_requests')->default(true);
            $table->boolean('revision_requests_email')->default(true);
            $table->boolean('revision_requests_in_app')->default(true);
            
            // Payment notifications
            $table->boolean('payment_confirmations')->default(true);
            $table->boolean('payment_confirmations_email')->default(true);
            $table->boolean('payment_confirmations_in_app')->default(true);
            
            $table->boolean('payment_failures')->default(true);
            $table->boolean('payment_failures_email')->default(true);
            $table->boolean('payment_failures_in_app')->default(true);
            
            $table->boolean('refunds')->default(true);
            $table->boolean('refunds_email')->default(true);
            $table->boolean('refunds_in_app')->default(true);
            
            $table->boolean('invoice_ready')->default(true);
            $table->boolean('invoice_ready_email')->default(true);
            $table->boolean('invoice_ready_in_app')->default(true);
            
            // Communication notifications
            $table->boolean('new_messages')->default(true);
            $table->boolean('new_messages_email')->default(true);
            $table->boolean('new_messages_in_app')->default(true);
            
            $table->boolean('writer_questions')->default(true);
            $table->boolean('writer_questions_email')->default(true);
            $table->boolean('writer_questions_in_app')->default(true);
            
            // System notifications
            $table->boolean('system_announcements')->default(true);
            $table->boolean('system_announcements_email')->default(true);
            $table->boolean('system_announcements_in_app')->default(true);
            
            $table->boolean('promotional_emails')->default(true);
            $table->boolean('coupon_alerts')->default(true);
            $table->boolean('coupon_alerts_email')->default(true);
            $table->boolean('coupon_alerts_in_app')->default(true);
            
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unique('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_preferences');
    }
}