<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('coupon_code');
            $table->string('discount_type');
            $table->string('discount_amount');
            $table->enum('coupon_type', ['first_order', 'flash', 'referral', 'loyalty', 'anniversary', 'seasonal', 'volume']);
            $table->unsignedBigInteger('loyalty_tier_id')->nullable();
            $table->unsignedBigInteger('seasonal_type_id')->nullable();
            $table->timestamp('start_date')->nullable();
            $table->timestamp('expiry_date')->nullable();
            $table->integer('max_uses')->nullable();
            $table->integer('uses_count')->default(0);
            $table->integer('per_user_limit')->nullable();
            $table->decimal('min_order_amount', 10, 2)->nullable();
            $table->integer('min_pages')->nullable();
            $table->integer('min_years')->nullable()->comment('Minimum years of membership required for anniversary coupons');
            $table->boolean('is_first_order_only')->default(0);
            $table->boolean('user_specific')->default(0);
            $table->unsignedBigInteger('referrer_user_id')->nullable();
            $table->boolean('is_referral')->default(0);
            $table->boolean('is_active')->default(1);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
            
            $table->foreign('loyalty_tier_id')->references('id')->on('loyalty_tiers')->onDelete('set null');
            $table->foreign('seasonal_type_id')->references('id')->on('seasonal_types')->onDelete('set null');
            $table->foreign('referrer_user_id')->references('id')->on('users')->onDelete('set null');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('deleted_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
}
