<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterProfilesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_profiles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('nickname', 200)->nullable();
            $table->string('profile_image', 255)->nullable();
            $table->text('bio')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->unsignedBigInteger('education_level_id')->nullable();
            $table->unsignedBigInteger('specialization_id')->nullable();
            $table->unsignedBigInteger('writer_level_id')->nullable();
            $table->boolean('is_available')->default(0);
            $table->integer('experience_years')->default(0);
            $table->decimal('hourly_rate', 8, 2)->nullable();
            $table->timestamp('last_active_at')->nullable();
            $table->timestamp('last_bid_at')->nullable();
            $table->timestamps();
            
            $table->index('user_id', 'writer_profiles_user_id_index');
            $table->index('country_id', 'writer_profiles_country_id_index');
            $table->index('education_level_id', 'writer_profiles_education_level_id_index');
            $table->index('specialization_id', 'writer_profiles_specialization_id_index');
            $table->index('writer_level_id', 'writer_profiles_writer_level_id_index');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('country_id')->references('id')->on('countries')->onDelete('set null');
            $table->foreign('education_level_id')->references('id')->on('writer_education_levels')->onDelete('set null');
            $table->foreign('specialization_id')->references('id')->on('writer_specializations')->onDelete('set null');
            $table->foreign('writer_level_id')->references('id')->on('writer_levels')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_profiles');
    }
}
