<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterPreferredCitationStylesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_preferred_citation_styles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('citation_style_id');
            $table->enum('proficiency_level', ['basic', 'intermediate', 'advanced', 'expert'])->default('intermediate');
            $table->timestamps();
            
            $table->unique(['writer_profile_id', 'citation_style_id'], 'unique_writer_citation');
            $table->index('citation_style_id', 'preferred_citation_style_id_index');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('citation_style_id')->references('id')->on('writer_citation_styles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_preferred_citation_styles');
    }
}
