<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTimelineTrackingToOrdersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Add tracking fields for the timeline system
            $table->timestamp('status_changed_at')->nullable()->after('order_status');
            $table->unsignedBigInteger('status_changed_by')->nullable()->after('status_changed_at');
            $table->text('status_change_reason')->nullable()->after('status_changed_by');
            
            // Timeline tracking fields
            $table->timestamp('writer_assigned_at')->nullable()->after('status_change_reason');
            $table->timestamp('work_started_at')->nullable()->after('writer_assigned_at');
            $table->timestamp('work_submitted_at')->nullable()->after('work_started_at');
            $table->timestamp('admin_reviewed_at')->nullable()->after('work_submitted_at');
            $table->timestamp('client_review_started_at')->nullable()->after('admin_reviewed_at');
            $table->timestamp('client_approved_at')->nullable()->after('client_review_started_at');
            $table->timestamp('auto_approval_at')->nullable()->after('client_approved_at');
            
            // Revision tracking
            $table->text('revision_notes')->nullable()->after('auto_approval_at');
            $table->unsignedInteger('revision_count')->default(0)->after('revision_notes');
            
            // Add indexes for performance
            $table->index(['status_changed_at']);
            $table->index(['writer_assigned_at']);
            $table->index(['work_submitted_at']);
            $table->index(['client_approved_at']);
            
            // Add foreign key for status_changed_by
            $table->foreign('status_changed_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['status_changed_by']);
            
            // Drop indexes
            $table->dropIndex(['status_changed_at']);
            $table->dropIndex(['writer_assigned_at']);
            $table->dropIndex(['work_submitted_at']);
            $table->dropIndex(['client_approved_at']);
            
            // Drop columns
            $table->dropColumn([
                'status_changed_at',
                'status_changed_by',
                'status_change_reason',
                'writer_assigned_at',
                'work_started_at',
                'work_submitted_at',
                'admin_reviewed_at',
                'client_review_started_at',
                'client_approved_at',
                'auto_approval_at',
                'revision_notes',
                'revision_count'
            ]);
        });
    }
} 