<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterQualificationTestsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_qualification_tests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->enum('questions_test_status', ['not_started', 'questions_pending', 'questions_failed', 'passed'])->default('not_started');
            $table->integer('questions_score')->nullable();
            $table->timestamp('questions_completed_at')->nullable();
            $table->timestamp('last_failed_at')->nullable();
            $table->timestamp('can_retry_after')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('expected_end_at')->nullable();
            $table->timestamp('last_activity_at')->nullable();
            $table->integer('time_extensions')->default(0);
            $table->string('session_token', 255)->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->boolean('is_time_violation')->default(false);
            $table->text('time_violation_notes')->nullable();
            $table->timestamp('auto_processed_at')->nullable();
            $table->timestamps();
            
            $table->index('writer_profile_id', 'writer_qualification_tests_writer_profile_id_index');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_qualification_tests');
    }
}
