<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterSubjectExpertiseTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_subject_expertise', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('academic_subject_id');
            $table->enum('proficiency_level', ['beginner', 'intermediate', 'advanced', 'expert'])->default('intermediate');
            $table->integer('years_experience')->nullable();
            $table->timestamps();
            
            $table->unique(['writer_profile_id', 'academic_subject_id'], 'unique_writer_subject');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('academic_subject_id')->references('id')->on('academic_subjects')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_subject_expertise');
    }
}
