<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterWorkSamplesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_work_samples', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('writer_profile_id');
            $table->unsignedBigInteger('academic_subject_id')->nullable();
            $table->string('title', 255);
            $table->text('description')->nullable();
            $table->string('file_path', 255);
            $table->string('file_type', 50)->nullable();
            $table->integer('file_size')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->timestamps();
            
            $table->index('writer_profile_id', 'writer_work_samples_writer_profile_id_index');
            $table->index('academic_subject_id', 'writer_work_samples_academic_subject_id_index');
            $table->foreign('writer_profile_id')->references('id')->on('writer_profiles')->onDelete('cascade');
            $table->foreign('academic_subject_id')->references('id')->on('academic_subjects')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_work_samples');
    }
}
