<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBlogPostTagsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blog_post_tags', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('blog_post_id');
            $table->unsignedBigInteger('tag_id');
            $table->timestamps();
            
            $table->unique(['blog_post_id', 'tag_id'], 'blog_post_tags_blog_post_id_tag_id_unique');
            $table->index('blog_post_id', 'blog_post_tags_blog_post_id_index');
            $table->index('tag_id', 'blog_post_tags_tag_id_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_post_tags');
    }
}
