<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusManagementToConversationsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            $table->enum('status', ['active', 'resolved', 'archived', 'escalated'])->default('active')->after('id');
            $table->timestamp('resolved_at')->nullable()->after('status');
            $table->unsignedBigInteger('resolved_by')->nullable()->after('resolved_at');
            $table->timestamp('archived_at')->nullable()->after('resolved_by');
            $table->unsignedBigInteger('archived_by')->nullable()->after('archived_at');
            $table->timestamp('last_activity_at')->nullable()->after('archived_by');
            $table->integer('priority_level')->default(1)->after('last_activity_at'); // 1=low, 5=urgent
            
            // Foreign key constraints
            $table->foreign('resolved_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('archived_by')->references('id')->on('users')->onDelete('set null');
            
            // Index for performance
            $table->index(['status', 'last_activity_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            // Drop foreign keys first
            $table->dropForeign(['resolved_by']);
            $table->dropForeign(['archived_by']);
            
            // Drop index
            $table->dropIndex(['status', 'last_activity_at']);
            
            // Drop columns
            $table->dropColumn([
                'status',
                'resolved_at',
                'resolved_by',
                'archived_at',
                'archived_by',
                'last_activity_at',
                'priority_level'
            ]);
        });
    }
}
