<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWriterPaymentRecordsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('writer_payment_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('writer_id')->constrained('users')->onDelete('cascade');
            
            // Payment details
            $table->decimal('payment_amount', 10, 2);
            $table->string('currency', 3)->default('USD');
            
            // Payment status tracking
            $table->enum('status', ['pending', 'available', 'withdrawn', 'processing', 'disputed'])->default('pending');
            
            // Tracking timestamps
            $table->timestamp('earned_at')->nullable(); // When work was completed/approved
            $table->timestamp('available_at')->nullable(); // When payment became available for withdrawal
            $table->timestamp('withdrawn_at')->nullable(); // When payment was actually withdrawn
            
            // Withdrawal tracking
            $table->unsignedBigInteger('withdrawal_request_id')->nullable();
            $table->unsignedBigInteger('withdrawal_batch_id')->nullable();
            
            // Payment method used for withdrawal
            $table->string('payment_method')->nullable();
            $table->string('transaction_reference')->nullable();
            
            // Notes and metadata
            $table->text('notes')->nullable();
            $table->json('metadata')->nullable();
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['writer_id', 'status']);
            $table->index(['order_id', 'status']);
            $table->index('available_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('writer_payment_records');
    }
}
