<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderRatingsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_ratings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('client_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('writer_id')->constrained('users')->onDelete('cascade');
            
            // Rating details
            $table->unsignedTinyInteger('overall_rating'); // 1-5 stars
            $table->unsignedTinyInteger('quality_rating')->nullable(); // 1-5 stars
            $table->unsignedTinyInteger('communication_rating')->nullable(); // 1-5 stars
            $table->unsignedTinyInteger('timeliness_rating')->nullable(); // 1-5 stars
            $table->unsignedTinyInteger('value_rating')->nullable(); // 1-5 stars
            
            // Review content
            $table->string('review_title')->nullable();
            $table->text('review_text')->nullable();
            $table->boolean('is_anonymous')->default(false);
            $table->boolean('is_verified')->default(true); // All ratings from completed orders are verified
            
            // Rating categories/tags
            $table->json('rating_categories')->nullable(); // e.g., ['grammar', 'research', 'formatting']
            $table->json('rating_tags')->nullable(); // e.g., ['professional', 'creative', 'thorough']
            
            // Metadata
            $table->json('metadata')->nullable(); // Additional data like device, browser, etc.
            $table->timestamp('rated_at');
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['order_id']);
            $table->index(['writer_id']);
            $table->index(['client_id']);
            $table->index(['overall_rating']);
            $table->index(['rated_at']);
            $table->index(['is_verified']);
            
            // Ensure one rating per order
            $table->unique(['order_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_ratings');
    }
}
