<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingFieldsToOrderRevisionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_revisions', function (Blueprint $table) {
            // Add missing fields for complete revision system
            $table->boolean('is_client_requested')->default(false)->after('revision_number');
            $table->text('client_notes')->nullable()->after('is_client_requested');
            $table->integer('quality_rating')->nullable()->change()->comment('1-10 rating of revision quality');
            $table->decimal('payment_impact', 8, 2)->default(0)->after('quality_bonus')->comment('Total payment impact (bonus - penalty)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_revisions', function (Blueprint $table) {
            $table->dropColumn(['is_client_requested', 'client_notes', 'payment_impact']);
            $table->integer('quality_rating')->nullable()->change()->comment('1-5 rating of revision quality');
        });
    }
} 