<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSubmissionTimingFieldsToOrdersTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->boolean('submission_was_late')->default(false)->after('work_submitted_at')->comment('Whether the work was submitted after the deadline');
            $table->integer('submission_late_by_hours')->default(0)->after('submission_was_late')->comment('How many hours late the submission was');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['submission_was_late', 'submission_late_by_hours']);
        });
    }
}
