<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageContentTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_content', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->constrained()->onDelete('cascade');
            $table->string('block_type'); // hero, overview, process, benefits, testimonials, faqs, etc.
            $table->string('block_key')->nullable(); // unique identifier for the block
            $table->json('content'); // flexible content structure
            $table->integer('order')->default(0); // display order
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            // Indexes
            $table->index(['page_id', 'block_type']);
            $table->index(['page_id', 'order']);
            $table->index(['block_type']);
            $table->index(['is_active']);
            
            // Unique constraint for block_key per page
            $table->unique(['page_id', 'block_key'], 'page_content_block_key_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_content');
    }
}
