<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageRelationshipsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('page_relationships', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->constrained()->onDelete('cascade');
            $table->foreignId('related_page_id')->constrained('pages')->onDelete('cascade');
            $table->enum('relationship_type', ['internal_link', 'related_service', 'support_page', 'resource_link'])->default('internal_link');
            $table->string('link_text')->nullable();
            $table->string('link_context')->nullable(); // where this link appears
            $table->integer('order')->default(0);
            $table->timestamps();
            
            // Indexes
            $table->index(['page_id']);
            $table->index(['related_page_id']);
            $table->index(['relationship_type']);
            $table->index(['link_context']);
            $table->index(['page_id', 'order']);
            
            // Note: Self-referencing prevention will be handled at application level
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('page_relationships');
    }
}
