<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('blog_categories')->insert([
            [
                'id' => 1,
                'name' => 'Essay Writing',
                'slug' => 'essay-writing',
                'description' => 'Tips and guides for writing excellent essays',
                'color' => 'blue',
                'icon' => 'FileText',
                'meta_title' => 'Essay Writing Tips & Guides | Academic Scribe Blog',
                'meta_description' => 'Master essay writing with expert tips, structure guides, and proven techniques for academic success.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 2,
                'name' => 'Research Papers',
                'slug' => 'research-papers',
                'description' => 'Research methodology and paper writing guidance',
                'color' => 'green',
                'icon' => 'Search',
                'meta_title' => 'Research Paper Writing Guides | Academic Scribe Blog',
                'meta_description' => 'Learn research paper writing techniques, methodology, and citation styles from academic experts.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 3,
                'name' => 'Academic Writing',
                'slug' => 'academic-writing',
                'description' => 'General academic writing skills and techniques',
                'color' => 'purple',
                'icon' => 'BookOpen',
                'meta_title' => 'Academic Writing Tips & Techniques | Academic Scribe Blog',
                'meta_description' => 'Improve your academic writing skills with expert tips, techniques, and best practices.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 4,
                'name' => 'Study Tips',
                'slug' => 'study-tips',
                'description' => 'Study strategies and academic success tips',
                'color' => 'orange',
                'icon' => 'Award',
                'meta_title' => 'Study Tips & Academic Success Strategies | Academic Scribe Blog',
                'meta_description' => 'Discover effective study tips and strategies for academic success and better grades.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 5,
                'name' => 'Case Studies',
                'slug' => 'case-studies',
                'description' => 'Case study analysis, writing guides, and presentation tips',
                'color' => 'indigo',
                'icon' => 'Briefcase',
                'meta_title' => 'Case Studies Tips & Guides | Academic Scribe Blog',
                'meta_description' => 'Master case study analysis with expert tips, business case studies, and presentation techniques.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 6,
                'name' => 'Literature Review',
                'slug' => 'literature-review',
                'description' => 'Literature review writing and research strategies',
                'color' => 'teal',
                'icon' => 'BookOpen',
                'meta_title' => 'Literature Review Writing Guides | Academic Scribe Blog',
                'meta_description' => 'Learn literature review writing techniques, search strategies, and systematic review methods.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 7,
                'name' => 'Assignments',
                'slug' => 'assignments',
                'description' => 'Assignment writing guides and topic ideas',
                'color' => 'red',
                'icon' => 'ClipboardList',
                'meta_title' => 'Assignment Writing Tips & Guides | Academic Scribe Blog',
                'meta_description' => 'Master assignment writing with expert guides, topic ideas, and proven techniques for academic success.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 8,
                'name' => 'Dissertation Writing',
                'slug' => 'dissertation-writing',
                'description' => 'Dissertation writing and defense strategies',
                'color' => 'yellow',
                'icon' => 'BookOpen',
                'meta_title' => 'Dissertation Writing & Defense Tips | Academic Scribe Blog',
                'meta_description' => 'Learn dissertation writing techniques, defense strategies, and doctoral research methods from experts.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 9,
                'name' => 'PhD Writing',
                'slug' => 'phd-writing',
                'description' => 'Advanced doctoral writing tips and techniques',
                'color' => 'pink',
                'icon' => 'GraduationCap',
                'meta_title' => 'PhD Writing Tips & Techniques | Academic Scribe Blog',
                'meta_description' => 'Master PhD writing with advanced techniques, doctoral communication skills, and scholarly writing tips.',
                'created_at' => '2025-07-16 18:15:47',
                'updated_at' => '2025-07-16 18:15:47',
            ],
            [
                'id' => 10,
                'name' => 'Personal Statements',
                'slug' => 'personal-statements',
                'description' => 'Articles about Personal Statements',
                'color' => 'blue',
                'icon' => 'BookOpen',
                'meta_title' => null,
                'meta_description' => null,
                'created_at' => '2025-07-19 15:38:41',
                'updated_at' => '2025-07-19 15:38:41',
            ],
            [
                'id' => 11,
                'name' => 'International Students',
                'slug' => 'international-students',
                'description' => 'Articles about International Students',
                'color' => 'blue',
                'icon' => 'BookOpen',
                'meta_title' => null,
                'meta_description' => null,
                'created_at' => '2025-07-20 00:23:10',
                'updated_at' => '2025-07-20 00:23:10',
            ],
        ]);
    }
}
