<?php

namespace Database\Seeders;

use App\Models\PaymentMethod;
use Illuminate\Database\Seeder;

class PaymentMethodsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // PayPal Payment Method
        PaymentMethod::updateOrCreate(
            ['name' => 'paypal'],
            [
                'display_name' => 'PayPal',
                'is_active' => true,
                'config_data' => json_encode([
                    'mode' => 'sandbox',
                    'client_id' => env('PAYPAL_SANDBOX_CLIENT_ID', 'AVtJ8z8XtAW1RJk5mxbUuTMN5UTbBBv-UkI6vsrm0G6zbz5TzrxZG9yx2S4s3rDPbivkt8XMPqYCBvZw'),
                    'client_secret' => env('PAYPAL_SANDBOX_CLIENT_SECRET', 'EHFAclDBTAQsPCGL-ZLHmR7ITUyOf-MrEZuQ4gc7HeDnT1LDLFzGO8bmoyv_Jn_Wt1NNv-beaiaA0NOu'),
                    'currency' => 'USD',
                ]),
            ]
        );

        // Stripe Payment Method
        PaymentMethod::updateOrCreate(
            ['name' => 'stripe'],
            [
                'display_name' => 'Credit/Debit Card',
                'is_active' => true,
                'config_data' => json_encode([
                    'publishable_key' => env('STRIPE_KEY'),
                    'secret_key' => env('STRIPE_SECRET'),
                    'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
                    'currency' => 'USD',
                ]),
            ]
        );

        // PayPal Direct Payment Method
        PaymentMethod::updateOrCreate(
            ['name' => 'paypal_direct'],
            [
                'display_name' => 'PayPal (Direct Form)',
                'is_active' => true,
                'config_data' => json_encode([
                    'mode' => env('PAYPAL_DIRECT_MODE', 'sandbox'),
                    'business_email' => env('PAYPAL_DIRECT_BUSINESS_EMAIL'),
                    'sandbox_business_email' => env('PAYPAL_DIRECT_SANDBOX_EMAIL'),
                    'form_action_sandbox' => 'https://www.sandbox.paypal.com/cgi-bin/webscr',
                    'form_action_live' => 'https://www.paypal.com/cgi-bin/webscr',
                    'ipn_verify_sandbox' => 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr',
                    'ipn_verify_live' => 'https://ipnpb.paypal.com/cgi-bin/webscr',
                    'return_url' => env('PAYPAL_DIRECT_RETURN_URL'),
                    'cancel_url' => env('PAYPAL_DIRECT_CANCEL_URL'),
                    'notify_url' => env('PAYPAL_DIRECT_NOTIFY_URL'),
                ]),
            ]
        );
    }
}
