<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedAboutPageComplete extends Seeder
{
    public function run()
    {
        // Delete existing about page if it exists
        $existingPage = Page::where('slug', 'about')->first();
        if ($existingPage) {
            $existingPage->contentBlocks()->delete();
            $existingPage->seo()->delete();
            $existingPage->delete();
        }

        // Create the About page
        $page = Page::create([
            'title' => 'About Academic Scribe - Professional Academic Writing Service',
            'slug' => 'about',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 90,
            'published_at' => now(),
        ]);

        // Create SEO data (EXACT from original)
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'About Us | Professional Academic Writing Service | Academic Scribe',
            'meta_description' => 'Learn about Academic Scribe - a trusted academic writing service with 500+ expert writers, 50,000+ papers delivered, and 98% customer satisfaction. Professional essay writing, research papers, and dissertation help.',
            'meta_keywords' => 'about academic scribe, professional essay writing service, academic writing company, expert writers, custom essays, research paper help, dissertation writing, assignment assistance, academic support, online writing service',
            'canonical_url' => 'https://academicscribe.com/about',
            'robots' => 'index, follow',
            'og_title' => 'About Academic Scribe | Professional Academic Writing Service',
            'og_description' => 'Discover Academic Scribe - your trusted partner for academic success. 500+ expert writers, 50,000+ papers delivered, 98% satisfaction rate. Professional essay writing and research assistance.',
            'og_image' => 'https://academicscribe.com/images/about-academic-scribe.jpg',
            'og_type' => 'website',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'About Academic Scribe | Professional Academic Writing Service',
            'twitter_description' => 'Trusted academic writing service with expert writers, guaranteed quality, and 24/7 support. Professional essay writing and research assistance.',
            'twitter_image' => 'https://academicscribe.com/images/about-academic-scribe.jpg',
        ]);

        // Block 1: Hero Section
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_hero',
            'block_key' => 'about_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'About Academic Scribe',
                'description' => 'Your trusted partner for academic success.<br/>Professional essay writing, research papers, and dissertation help from expert writers with advanced degrees.',
                'primaryButtonText' => 'Get Essay Help',
                'primaryButtonLink' => '/services/essay-writing',
                'secondaryButtonText' => 'Contact Us',
                'secondaryButtonLink' => '/contact',
            ]
        ]);

        // Block 2: Our Story & Mission
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_story',
            'block_key' => 'about_story',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Our Story & Mission',
                'description' => '<p class="text-gray-600 mb-4 text-lg">Founded in 2019, Academic Scribe emerged from a simple yet powerful vision: to provide students worldwide with access to high-quality academic writing assistance that helps them achieve their educational goals.</p><p class="text-gray-600 mb-4">Our team of expert writers, editors, and academic professionals understands the challenges students face in today\'s competitive academic environment. We\'re committed to delivering original, well-researched, and professionally written papers that serve as learning tools and academic support.</p><p class="text-gray-600 mb-6">With over 50,000 papers delivered and a 98% customer satisfaction rate, Academic Scribe has become a trusted name in academic writing services, helping students from high school to PhD level achieve academic excellence.</p>',
                'image' => [
                    'src' => '/images/about-story.jpg',
                    'alt' => 'Academic Scribe team working on academic writing projects'
                ],
                'badge' => [
                    'value' => '5+',
                    'label' => 'Years of Excellence'
                ],
                'linkText' => 'Explore Our Services',
                'linkUrl' => '/services',
            ]
        ]);

        // Block 3: Achievements (6 stats)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_achievements',
            'block_key' => 'about_achievements',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'Our Achievements',
                'description' => 'Numbers that reflect our commitment to academic excellence',
                'achievements' => [
                    [
                        'number' => '50,000+',
                        'label' => 'Papers Delivered',
                        'description' => 'Successfully completed academic assignments',
                    ],
                    [
                        'number' => '15,000+',
                        'label' => 'Happy Students',
                        'description' => 'Satisfied customers worldwide',
                    ],
                    [
                        'number' => '500+',
                        'label' => 'Expert Writers',
                        'description' => 'PhD and Masters qualified professionals',
                    ],
                    [
                        'number' => '98%',
                        'label' => 'Success Rate',
                        'description' => 'Customer satisfaction guarantee',
                    ],
                    [
                        'number' => '24/7',
                        'label' => 'Support Available',
                        'description' => 'Round-the-clock customer assistance',
                    ],
                    [
                        'number' => '5+',
                        'label' => 'Years Experience',
                        'description' => 'Trusted academic writing service',
                    ],
                ]
            ]
        ]);

        // Block 4: Our Core Values (6 values)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_values',
            'block_key' => 'about_values',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'Our Core Values',
                'description' => 'The principles that guide our academic writing service',
                'values' => [
                    [
                        'icon' => '🎯',
                        'title' => 'Academic Excellence',
                        'description' => 'We maintain the highest standards of academic writing, ensuring every paper meets university-level requirements and exceeds expectations.',
                    ],
                    [
                        'icon' => '🔒',
                        'title' => 'Integrity & Originality',
                        'description' => 'Every paper is written from scratch with 100% original content. We guarantee plagiarism-free work with proper citations and references.',
                    ],
                    [
                        'icon' => '⏰',
                        'title' => 'Timely Delivery',
                        'description' => 'We understand the importance of deadlines. Our writers work efficiently to deliver your papers on time, every time.',
                    ],
                    [
                        'icon' => '🤝',
                        'title' => 'Student Success',
                        'description' => 'Your academic success is our priority. We provide personalized support and guidance to help you achieve your educational goals.',
                    ],
                    [
                        'icon' => '🛡️',
                        'title' => 'Confidentiality',
                        'description' => 'Your privacy is paramount. We maintain strict confidentiality and never share your personal information or order details.',
                    ],
                    [
                        'icon' => '💎',
                        'title' => 'Quality Assurance',
                        'description' => 'Multi-level quality checks ensure every paper meets our rigorous standards before delivery to our valued customers.',
                    ],
                ]
            ]
        ]);

        // Block 5: Our Academic Writing Services (6 services)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_services',
            'block_key' => 'about_services',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'Our Academic Writing Services',
                'description' => 'Comprehensive academic support for all your writing needs',
                'services' => [
                    [
                        'icon' => '📝',
                        'title' => 'Essay Writing',
                        'description' => 'Custom essays for all academic levels and subjects',
                        'link' => '/services/essay-writing',
                    ],
                    [
                        'icon' => '🔬',
                        'title' => 'Research Papers',
                        'description' => 'In-depth research and analysis papers',
                        'link' => '/services/research-papers',
                    ],
                    [
                        'icon' => '🎓',
                        'title' => 'Dissertation Help',
                        'description' => 'Comprehensive dissertation writing assistance',
                        'link' => '/services/dissertations',
                    ],
                    [
                        'icon' => '📚',
                        'title' => 'Assignment Help',
                        'description' => 'All types of academic assignments',
                        'link' => '/services/assignments',
                    ],
                    [
                        'icon' => '📖',
                        'title' => 'Literature Reviews',
                        'description' => 'Comprehensive literature analysis',
                        'link' => '/services/literature-reviews',
                    ],
                    [
                        'icon' => '💼',
                        'title' => 'Case Studies',
                        'description' => 'Professional case study analysis',
                        'link' => '/services/case-studies',
                    ],
                ],
                'ctaText' => 'View All Services',
                'ctaLink' => '/services',
            ]
        ]);

        // Block 6: Why Choose Us (6 reasons)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_why_choose',
            'block_key' => 'about_why_choose',
            'order' => 6,
            'is_active' => true,
            'content' => [
                'title' => 'Why Choose Academic Scribe?',
                'description' => 'What sets us apart in the academic writing industry',
                'reasons' => [
                    [
                        'title' => 'Expert Writers with Advanced Degrees',
                        'description' => 'Our team consists of 500+ professional writers with PhD and Masters degrees from top universities, ensuring expert-level academic writing assistance.',
                        'iconPath' => 'M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z',
                    ],
                    [
                        'title' => '100% Original & Plagiarism-Free',
                        'description' => 'Every paper is written from scratch with original content. We provide free plagiarism reports and guarantee authentic academic work.',
                        'iconPath' => 'M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z',
                    ],
                    [
                        'title' => 'On-Time Delivery Guaranteed',
                        'description' => 'We understand the importance of deadlines. Our efficient workflow ensures timely delivery of all academic assignments.',
                        'iconPath' => 'M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z',
                    ],
                    [
                        'title' => '24/7 Customer Support',
                        'description' => 'Our dedicated support team is available round-the-clock to assist with your questions and provide updates on your orders.',
                        'iconPath' => 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z',
                    ],
                    [
                        'title' => 'Complete Confidentiality',
                        'description' => 'Your privacy is our priority. We maintain strict confidentiality and never share your personal information or order details.',
                        'iconPath' => 'M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z',
                    ],
                    [
                        'title' => 'Money-Back Guarantee',
                        'description' => 'We stand behind our work with a comprehensive money-back guarantee. Your satisfaction is our commitment.',
                        'iconPath' => 'M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z',
                    ],
                ]
            ]
        ]);

        // Block 7: How Academic Scribe Works (4 steps)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_process',
            'block_key' => 'about_process',
            'order' => 7,
            'is_active' => true,
            'content' => [
                'title' => 'How Academic Scribe Works',
                'description' => 'Simple steps to get professional academic writing help',
                'steps' => [
                    [
                        'number' => '1',
                        'title' => 'Place Your Order',
                        'description' => 'Fill out our simple order form with your assignment details, requirements, and deadline.',
                    ],
                    [
                        'number' => '2',
                        'title' => 'Writer Assignment',
                        'description' => 'We match your order with the most qualified expert writer in your subject area.',
                    ],
                    [
                        'number' => '3',
                        'title' => 'Writing & Quality Check',
                        'description' => 'Your writer creates original content while our quality team ensures it meets all requirements.',
                    ],
                    [
                        'number' => '4',
                        'title' => 'Delivery & Support',
                        'description' => 'Receive your completed paper on time with free revisions and ongoing support.',
                    ],
                ],
                'ctaText' => 'Start Your Order Now',
                'ctaLink' => '/order',
            ]
        ]);

        // Block 8: Testimonials (3 testimonials)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_testimonials',
            'block_key' => 'about_testimonials',
            'order' => 8,
            'is_active' => true,
            'content' => [
                'title' => 'What Our Students Say',
                'description' => 'Real feedback from satisfied customers',
                'testimonials' => [
                    [
                        'quote' => 'Academic Scribe helped me with my research paper and the quality was outstanding. The writer understood my requirements perfectly and delivered on time.',
                        'name' => 'Sarah M.',
                        'title' => 'Psychology Major',
                        'initials' => 'SM',
                        'rating' => 5,
                    ],
                    [
                        'quote' => 'Excellent service! The essay was well-researched, properly formatted, and plagiarism-free. I received an A+ on my assignment.',
                        'name' => 'Michael R.',
                        'title' => 'Business Student',
                        'initials' => 'MR',
                        'rating' => 5,
                    ],
                    [
                        'quote' => 'Professional writers and excellent customer support. They helped me with my dissertation and I couldn\'t be happier with the results.',
                        'name' => 'Emily C.',
                        'title' => 'Graduate Student',
                        'initials' => 'EC',
                        'rating' => 5,
                    ],
                ]
            ]
        ]);

        // Block 9: FAQ Section
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_faqs',
            'block_key' => 'about_faqs',
            'order' => 9,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions',
                'description' => 'Common questions about our academic writing service',
                'faqs' => [
                    [
                        'question' => 'What makes Academic Scribe different from other writing services?',
                        'answer' => 'Academic Scribe stands out with our team of 500+ expert writers holding advanced degrees, rigorous quality control processes, 24/7 customer support, and a 98% customer satisfaction rate. We guarantee original, plagiarism-free work with on-time delivery.',
                    ],
                    [
                        'question' => 'Are your writers qualified to handle academic assignments?',
                        'answer' => 'Yes, all our writers hold Masters or PhD degrees from accredited universities. They undergo rigorous screening and testing before joining our team, ensuring they can handle assignments from high school to PhD level.',
                    ],
                    [
                        'question' => 'How do you ensure the originality of the papers?',
                        'answer' => 'Every paper is written from scratch by our expert writers. We provide free plagiarism reports using advanced detection software and guarantee 100% original content with proper citations and references.',
                    ],
                    [
                        'question' => 'What if I need revisions on my paper?',
                        'answer' => 'We offer unlimited free revisions to ensure your complete satisfaction. If you need any changes, simply request them and your writer will make the necessary adjustments at no extra cost.',
                    ],
                    [
                        'question' => 'Is my personal information safe with Academic Scribe?',
                        'answer' => 'Absolutely. We maintain strict confidentiality and never share your personal information or order details with third parties. Your privacy and security are our top priorities.',
                    ],
                    [
                        'question' => 'Do you offer support for urgent assignments?',
                        'answer' => 'Yes, we provide 24/7 customer support and can handle urgent assignments with deadlines as short as 3 hours. Our efficient workflow ensures timely delivery even for last-minute orders.',
                    ],
                ]
            ]
        ]);

        // Block 10: Final CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'about_cta',
            'block_key' => 'about_cta',
            'order' => 10,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Get Professional Academic Help?',
                'description' => 'Join thousands of satisfied students who have achieved academic success with Academic Scribe. Get expert writing assistance tailored to your needs.',
                'primaryButtonText' => 'Order Now',
                'primaryButtonLink' => '/order',
                'secondaryButtonText' => 'Contact Us',
                'secondaryButtonLink' => '/contact',
                'trustBadges' => [
                    '500+ Expert Writers',
                    '50,000+ Papers Delivered',
                    '98% Success Rate',
                    '24/7 Support',
                ]
            ]
        ]);

        $this->command->info('✅ About page created successfully with all content blocks!');
        $this->command->info('   - Hero with CTA buttons');
        $this->command->info('   - Our Story & Mission with image badge');
        $this->command->info('   - 6 achievement stats');
        $this->command->info('   - 6 core values');
        $this->command->info('   - 6 academic services');
        $this->command->info('   - 6 reasons to choose us');
        $this->command->info('   - 4-step process');
        $this->command->info('   - 3 testimonials');
        $this->command->info('   - 6 FAQs');
        $this->command->info('   - Final CTA with trust badges');
    }
}




