<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedContactPage extends Seeder
{
    public function run()
    {
        // Create the Contact page
        $page = Page::create([
            'title' => 'Contact Us - Academic Scribe',
            'slug' => 'contact',
            'page_type' => 'contact',
            'status' => 'published',
            'template' => 'contact',
            'seo_priority' => 90,
            'published_at' => now(),
        ]);

        // Create SEO data
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Contact Us - Academic Scribe | 24/7 Customer Support',
            'meta_description' => 'Get in touch with Academic Scribe for all your academic writing needs. 24/7 customer support, fast response time, and professional assistance. Contact us today!',
            'meta_keywords' => 'contact academic scribe, customer support, academic writing help, contact us, get in touch, 24/7 support',
            'canonical_url' => 'https://academicscribe.com/contact',
            'robots' => 'index, follow',
            'og_title' => 'Contact Academic Scribe - 24/7 Customer Support',
            'og_description' => 'Get professional academic writing support. Contact our expert team for assistance with essays, dissertations, research papers, and more. Available 24/7.',
            'og_image' => 'https://academicscribe.com/images/contact-us-og.jpg',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Contact Academic Scribe - Expert Academic Writing Support',
            'twitter_description' => 'Get in touch with our professional academic writing team. 24/7 support for all your academic needs.',
            'structured_data' => [
                'organization' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'email' => 'support@academicscribe.com',
                        'areaServed' => 'Worldwide',
                        'availableLanguage' => ['English'],
                        'hoursAvailable' => [
                            '@type' => 'OpeningHoursSpecification',
                            'dayOfWeek' => ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'],
                            'opens' => '00:00',
                            'closes' => '23:59'
                        ]
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe'
                    ]
                ],
                'webpage' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'ContactPage',
                    'name' => 'Contact Us - Academic Scribe',
                    'description' => 'Get in touch with Academic Scribe for professional academic writing support',
                    'url' => 'https://academicscribe.com/contact'
                ]
            ]
        ]);

        // Content Block 1: Hero Section
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'hero',
            'block_key' => 'contact_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Contact Us',
                'description' => 'Have a question or need assistance? We\'re here to help. Get in touch with our team and we\'ll respond as soon as possible.',
            ]
        ]);

        // Content Block 2: Contact Information
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'contact_info',
            'block_key' => 'contact_information',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Get in Touch',
                'contact_methods' => [
                    [
                        'type' => 'email',
                        'icon' => 'mail',
                        'label' => 'Email',
                        'value' => 'support@academicscribe.com',
                        'color' => 'blue'
                    ],
                    [
                        'type' => 'time',
                        'icon' => 'clock',
                        'label' => 'Response Time',
                        'value' => 'Within 24 hours',
                        'color' => 'green'
                    ],
                    [
                        'type' => 'support',
                        'icon' => 'chat',
                        'label' => 'Support Hours',
                        'value' => '24/7 Customer Support',
                        'color' => 'purple'
                    ]
                ]
            ]
        ]);

        // Content Block 3: Why Choose Us
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'features_grid',
            'block_key' => 'contact_why_choose',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'Why Choose Academic Scribe?',
                'features' => [
                    [
                        'icon' => 'check-circle',
                        'title' => 'Quality Assurance',
                        'description' => 'Professional writers with proven expertise',
                        'color' => 'blue'
                    ],
                    [
                        'icon' => 'clock',
                        'title' => 'Timely Delivery',
                        'description' => 'Always on time, every time',
                        'color' => 'green'
                    ],
                    [
                        'icon' => 'chat',
                        'title' => '24/7 Support',
                        'description' => 'Round-the-clock customer assistance',
                        'color' => 'purple'
                    ]
                ]
            ]
        ]);

        // Content Block 4: FAQs
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'faqs',
            'block_key' => 'contact_faqs',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions',
                'faqs' => [
                    [
                        'question' => 'How quickly will I receive a response?',
                        'answer' => 'We typically respond to all inquiries within 24 hours during business days.'
                    ],
                    [
                        'question' => 'What information should I include?',
                        'answer' => 'Please provide as much detail as possible about your inquiry to help us assist you better.'
                    ],
                    [
                        'question' => 'Can I track my inquiry?',
                        'answer' => 'Yes, you\'ll receive a confirmation email with a reference number for tracking.'
                    ],
                    [
                        'question' => 'Is my information secure?',
                        'answer' => 'Absolutely. We use industry-standard security measures to protect your data.'
                    ]
                ]
            ]
        ]);

        echo "✅ Contact page seeded successfully!\n";
        echo "   - Page: {$page->title}\n";
        echo "   - Slug: /{$page->slug}\n";
        echo "   - SEO: Complete\n";
        echo "   - Content Blocks: 4\n";
    }
}

